import datetime

class FitLog:
    def __init__(self, folderpath="", fname=None):
        if fname == None:
            fname = datetime.datetime.now().strftime("%y%m%d%H%M%S" + ".log")
        self.fh = open(folderpath + fname, 'w')
    
    def append(self, line, with_time=False, change_line=True):
        str2append = ""
        if with_time is False:
            str2append = line
        else:
            str2append = str(datetime.datetime.now()) + "  " + line

        if change_line is True:
            str2append += "\r\n"
            
        self.fh.write(str2append)
        self.fh.flush()

    def close(self):
        self.fh.flush()
        self.fh.close()
    