# LSTM

## 论文
- https://arxiv.org/pdf/1506.04214.pdf
## 模型结构
LSTM（长短期记忆网络）是一种特殊的循环神经网络（RNN）结构，通过引入输入门、遗忘门和输出门三个控制单元来调节信息的流动，从而有效解决传统RNN在处理长序列数据时的梯度消失或爆炸问题，能够更好地捕捉序列中的长期依赖关系。

![model](model1.png)


## 算法原理
LSTM通过引入输入门、遗忘门和输出门三个控制机制，动态地筛选和更新信息，从而有效捕捉序列数据中的长期依赖关系，解决传统RNN的梯度消失问题。

![model2](model2.png)


## 环境配置
### Docker（方法一）
此处提供[光源](https://www.sourcefind.cn/#/service-details)拉取docker镜像的地址与使用步骤
```
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.1.0-py3.10-dtk24.04.3-ubuntu20.04

docker run -it --name docker_name -v /path/your_code_data/:/path/your_code_data/ -v /opt/hyhal:/opt/hyhal:ro --network=host --shm-size=32G --privileged=true --device=/dev/kfd --ipc=host --device=/dev/dri/ --group-add video image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.1.0-py3.10-dtk24.04.3-ubuntu20.04 /bin/bash
```
### Dockerfile（方法二）
此处提供dockerfile的使用方法
```
cd ./docker
docker build --no-cache -t lstm:1.0 .
docker run -it -v /path/your_code_data/:/path/your_code_data/ --shm-size=32G --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name docker_name imageID /bin/bash
```
### Anaconda（方法三）
此处提供本地配置、编译的详细步骤，例如：

关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.hpccube.com/tool/)开发者社区下载安装。
```
DTK驱动：dtk24.04.3
python：python3.10
torch：2.1.0
torchvision：0.16.0
```
`Tips：以上dtk驱动、python、paddle等DCU相关工具版本需要严格一一对应`

除了上述包之外，还需要单独安装如下第三方库

```
pip install scikit-learn
pip install statsmodels
```




## 数据集
`dat_3day_pcase`

训练所用的数据集在工程根目录下，可通过hour_dataset.py文件得到dat_3day_pcase



## 训练
### 单机多卡
```
python -m torch.distributed.launch --nproc_per_node=8 driver.py 
```


## result

![result](result.png)



### 精度
测试数据：/data/下的s2数据集，使用的加速卡:K100_AI。

根据测试结果情况填写表格：
| 卡数 | 精度 |
| :------: | :------: |
| 8 | 0.7978 |
## 应用场景
### 算法类别
`情绪识别`

### 热点应用行业
应用行业的填写需要做大量调研，从而为使用者提供专业、全面的推荐，除特殊算法，通常推荐数量>=3。

`教育,科研,交通`

## 预训练权重
- 该工程为通用训练模型，不需要预训练权重文件
## 源码仓库及问题反馈
- https://developer.sourcefind.cn/codes/modelzoo/lstm_pytorch
## 参考资料
- https://github.com/pytorch/pytorch/blob/main/torch/nn/modules/rnn.py
