# License-Plate-Recoginition(LPR)
## 模型介绍
LPR是一个基于深度学习技术的车牌识别模型，主要识别目标是自然场景的车牌图像。
## 模型结构
模型采用LPRNet，模型结构主要包含三部分：一个轻量级CNN主干网络、基于预定位置的字符分类头部、基于贪婪算法的序列解码。此外模型使用CTC Loss和RMSprop优化器。
## 数据集
推荐使用一个车牌数据集[CCPD](https://github.com/detectRecog/CCPD "CCPD官网GitHub")，也可参考[CCPD](https://blog.csdn.net/LuohenYJ/article/details/117752120 "CCPD中文版介绍")，该数据集由中科大收集，可用于车牌的检测与识别。我们提供了一个脚本cut_ccpd.py用于剪裁出CCPD数据集中的车牌位置，以便用于LPR模型的训练，在cut_ccpd.py中修改img_path和save_path即可，分别是CCPD数据集中ccpd_base文件夹的路径和剪裁出的图像保存路径。LPR用于训练的数据文件名就是图像的标签。**数据集使用固定的大小94x24。**
## 训练及推理
### 训练与Fine-tunning
LPR模型的训练程序是train.py，初次训练模型使用以下命令：

    python train.py \
        --train_img_dirs 训练集文件夹路径 \
        --test_img_dirs 验证集文件夹路径
Fine-tunning使用以下命令：

    python train.py \
        --train_img_dirs 训练集文件夹路径 \
        --test_img_dirs 验证集文件夹路径 \
        --pretrained_model 预训练模型路径 \
        --resume_epoch Fine-tuning训练的起始epoch \ #fine-tuning时只训练从起始epoch到最大epoch
        --max_epoch 训练的最大epoch
### 测试
LPR模型用test.py对训练出的模型进行测试，使用方法如下：

    python test.py \
        --model 需要测试的pth模型路径 \
        --imgpath 测试集路径 # 单张图像或文件夹皆可

        --export_onnx 该参数用于选择是否需要将pth模型转为onnx模型
        --dynamic 该参数用于选择onnx模型是否使用动态的batch size
### 推理
我们分别提供了基于OnnxRuntime(ORT)和Migraphx的推理脚本
#### ORT
LPRNet_ORT_infer.py是基于ORT的的推理脚本，使用方法：

    python LPRNet_ORT_infer.py --model onnx模型路径 --imgpath 数据路径(文件夹图像皆可)
#### Migraphx
LPRNet_migraphx_infer.py是基于Migraphx的推理脚本，使用需安装好Migraphx，支持onnx模型和mxr模型推理，mxr模型是migraphx将onnx模型保存成的离线推理引擎，初次使用onnx模型会保存对应的mxr模型。使用方法：

    python LPRNet_migraphx_infer.py --model mxr/onnx模型路径 --imgpath 数据路径(文件夹图像皆可) --savepath mxr模型的保存路径以及模型名称
## 性能和准确率数据
测试数据使用的是[LPRNet_Pytorch](https://github.com/sirius-ai/LPRNet_Pytorch/tree/master/data/test)

| size | personal test imgs(%) | DCU |
| :------: | :------: | :------: |
| 1.7M | 96.0+ | |
## 参考
* [LPRNet: License Plate Recognition via Deep Neural Networks](https://arxiv.org/pdf/1806.10447v1.pdf)
* [LPRNet_Pytorch](https://github.com/sirius-ai/LPRNet_Pytorch)
* [license-plate-detect-recoginition](https://github.com/qzpzd/license-plate-detect-recoginition)