# LongCat_sglang

## 论文
[LongCat-Flash Technical Report](https://github.com/meituan-longcat/LongCat-Flash-Chat/blob/main/tech_report.pdf)

## 模型结构
美团开源模型龙猫，一个强大且高效的混合专家（MoE）语言模型，拥有总计 5600 亿个参数，采用了创新的专家混合（MoE）架构。
该模型采用了一种动态计算机制，根据 token 的重要性为其动态分配计算预算，能够根据上下文需求激活 186 亿至 313 亿个参数（总共 5600 亿），从而在计算效率和性能之间实现了优化。

<div align=center>
    <img src="./doc/model.png"/>
</div>

## 算法原理
LongCat-Flash 是基于两个关键原则进行设计和优化的：高效计算利用以及高效训练和推理。具体而言:

(a) 零计算专家（Zero-computation Experts），支持动态计算预算分配，根据上下文需求，每个 token 激活 186 亿至 313 亿参数（平均 270 亿），优化了资源使用。
为确保计算负载一致，采用了由 PID 控制器调整的专家偏置，将每个 token 的平均激活参数维持在约 270 亿。

(b) 快捷连接 MoE（Shortcut-connected MoE），扩大了计算-通信重叠窗口，结合定制的基础设施优化，该设计能够支持在数万个加速器上进行大规模训练，并实现高吞吐量和低延迟的推理。

综合评估表明，作为一个非思维（non-thinking）基础模型，LongCat-Flash 在其他领先模型中提供了极具竞争力的性能，并在智能体任务方面表现出卓越的优势。

<div align=center>
    <img src="./doc/methods.png"/>
</div>

## 环境配置
### 硬件需求
DCU型号：K100_AI,节点数量：4台,卡数：32 张。

`-v 路径`、`docker_name`和`imageID`根据实际情况修改

### Docker（方法一）
```bash
docker pull image.sourcefind.cn:5000/dcu/admin/base/vllm:0.9.2-ubuntu22.04-dtk25.04.1-rc5-rocblas101839-0811-das1.6-py3.10-20250812-beta
docker run -it --shm-size 200g --network=host --name {docker_name} --privileged --device=/dev/kfd --device=/dev/dri --device=/dev/mkfd --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root -v /path/your_code_data/:/path/your_code_data/ -v /opt/hyhal/:/opt/hyhal/:ro {imageID} bash

## 安装sglang
git clone https://developer.sourcefind.cn/codes/OpenDAS/sglang

cd sglang
# 编译安装sgl-kernel包
cd sgl-kernel
python setup_hip.py install
# 安装sglang Python依赖
cd ..
pip install -e "python[all_hip]"
pip install transformers==4.56.0

cd /your_code_path/longcat_sglang
```

### Dockerfile（方法二）
```bash
cd docker
docker build --no-cache -t longcat:latest .
docker run -it --shm-size 200g --network=host --name {docker_name} --privileged --device=/dev/kfd --device=/dev/dri --device=/dev/mkfd --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root -v /path/your_code_data/:/path/your_code_data/ -v /opt/hyhal/:/opt/hyhal/:ro {imageID} bash

## 安装sglang
git clone https://developer.sourcefind.cn/codes/OpenDAS/sglang

cd sglang
# 编译安装sgl-kernel包
cd sgl-kernel
python setup_hip.py install
# 安装sglang Python依赖
cd ..
pip install -e "python[all_hip]"
pip install transformers==4.56.0

cd /your_code_path/longcat_sglang
```

### Anaconda（方法三）
关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.sourcefind.cn/tool/)开发者社区下载安装。
```bash
DTK: 25.04.1
python: 3.10.12
torch: 2.5.1+das.opt1.dtk25041
deepspeed: 0.14.2+das.opt1.dtk25041
transformers: 4.56.0
```
`Tips：以上dtk驱动、python、torch等DCU相关工具版本需要严格一一对应`

``` bash
## 安装sglang
git clone https://developer.sourcefind.cn/codes/OpenDAS/sglang

cd sglang
# 编译安装sgl-kernel包
cd sgl-kernel
python setup_hip.py install
# 安装sglang Python依赖
cd ..
pip install -e "python[all_hip]"
pip install transformers==4.56.0
```

## 数据集
无

## 训练
暂无

## 推理
### sglang推理方法
#### server 多机
样例模型：[LongCat-Flash-Chat](https://huggingface.co/meituan-longcat/LongCat-Flash-Chat)

启动sglang server，每个节点都需要启动
> 参数说明：
> x.x.x.x 对应主节点的IP
>
> 主节点NODE_RANK为0，工作节点分别为1，2，3
>
> nnodes 节点数量, 每个节点都需要执行下面脚本，NODE_RANK根据每个节点输入

主节点启动示例：
```bash
bash start_sglang.sh 0
```

启动完成后可通过以下方式访问：
```bash
curl http://127.0.0.2:8001/v1/chat/completions \
    -H "Content-Type: application/json" \
    -d '{
        "model": "meituan-longcat/LongCat-Flash-Chat",
        "messages": [
            {
                "role": "user",
                "content": "Explain Machine Learning to me in a nutshell."
            }
        ],
        "temperature": 0.15,
        "top_p": 1.0,
        "max_tokens": 2048,
        "stream": false
}'
```

## result
<div align=center>
    <img src="./doc/results-dcu.png"/>
</div>

### 精度
DCU与GPU精度一致，推理框架：sglang。

## 应用场景
### 算法类别
对话问答

### 热点应用行业
制造,广媒,家居,教育

## 预训练权重
- [LongCat-Flash-Chat](https://huggingface.co/meituan-longcat/LongCat-Flash-Chat)

## 源码仓库及问题反馈
- https://developer.sourcefind.cn/codes/modelzoo/longcat_sglang

## 参考资料
- https://github.com/meituan-longcat/LongCat-Flash-Chat
