# LoFTR
## 论文
[LoFTR](https://arxiv.org/pdf/2104.00680.pdf)


## 模型简介
本文提出了Local Feature Transformers （LoFTR），这是一种新的Detector-free的局部特征匹配方法。受SuperGlue的启发，本文使用了具有自注意层和互注意层的Transformer模块来处理从卷积网络中提取的密集局部特征：本文首先在低特征分辨率（图像维度的1/8）上提取密集匹配，然后从这些匹配中选择具有高可信度的匹配，使用基于相关的方法将其细化到高分辨率的亚像素级别。这样，模型的大接受域使转换后的特征符能够体现出上下文和位置信息，通过多次自注意力和互注意层，LoFTR学习在GT中的匹配先验。另外，本文还采用Linear Attention方法将计算复杂度降低到可接受的水平.

![alt text](image-1.png)

## 环境依赖

| 软件 | 版本 |
| :------: | :------: |
| DTK | 25.04.1 |
| python | 3.11 |
| torch | 2.4.1+das.opt1.dtk25041 |


推荐使用镜像:
- 挂载地址 `-v` 根据实际模型情况修改

```bash
docker run -it --shm-size 50g --network=host --name loftr --privileged --device=/dev/kfd --device=/dev/dri --device=/dev/mkfd --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root -v /opt/hyhal/:/opt/hyhal/:ro -v /path/your_code_path/:/path/your_code_path/ image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.4.1-ubuntu22.04-dtk25.04.1-py3.11 bash
```
更多镜像可前往[光源](https://sourcefind.cn/#/service-list)下载使用。

关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.sourcefind.cn/tool/)开发者社区下载安装，其它包参照requirements.txt安装：
```
pip install -r requirements.txt
```

## 数据集
[original MegaDepth dataset](https://www.cs.cornell.edu/projects/megadepth/dataset/Megadepth_v1/MegaDepth_v1.tar.gz) \
[D2-Net preprocessed images](https://drive.google.com/drive/folders/1hxpOsqOZefdrba_BqnW490XpNX_LgXPB) \
[ScanNet](https://github.com/ScanNet/ScanNet#scannet-data)

或者也可以下载处理过的数据 https://drive.google.com/drive/folders/1DOcOPZb3-5cWxLqn256AhwUVjBPifhuf

## 训练

<!-- ### 单机训练
```bash

``` -->

### 多机训练
```bash
# ScanNet
scripts/reproduce_train/indoor_ds.sh
# MegaDepth
scripts/reproduce_train/outdoor_ds.sh
```

## 推理

### 单机推理
```bash
# with shell script
bash ./scripts/reproduce_test/indoor_ds.sh
# or
python test.py configs/data/scannet_test_1500.py configs/loftr/loftr_ds.py --ckpt_path weights/indoor_ds.ckpt --profiler_name inference --gpus=1 --accelerator="ddp"
```

<!-- ### 多机推理
```bash

``` -->


### 精度
DCU与GPU精度一致

## 预训练权重
| 模型名称  | 权重大小  | DCU型号  | 最低卡数需求 |下载地址|
|:-----:|:----------:|:----------:|:---------------------:|:----------:|
| indoor_ds | - | K100AI | 1 | [下载地址](https://drive.google.com/drive/folders/1xu2Pq6mZT5hmFgiYMBT9Zt8h1yO-3SIp) |
| indoor_ot | - | K100AI | 1 | [下载地址](https://drive.google.com/drive/folders/1xu2Pq6mZT5hmFgiYMBT9Zt8h1yO-3SIp) |


## 源码仓库及问题反馈
- https://developer.sourcefind.cn/codes/modelzoo/loftr-pytorch

## 参考资料
- https://github.com/zju3dv/LoFTR
