# LLaVA-NeXT: Stronger LLMs Supercharge Multimodal Capabilities in the Wild

## 论文

`LLaVA-NeXT: Stronger LLMs Supercharge Multimodal Capabilities in the Wild`

* https://llava-vl.github.io/blog/2024-05-10-llava-next-stronger-llms/

## 模型结构

参考[README.md](../README.md)

## 算法原理

参考[README.md](../README.md)

## 数据集

无

## 训练

无

## 推理

```bash
python image.py
```

注意：在运行前需修改文件中的模型路径。

### 评估

```bash
export HF_ENDPOINT=https://hf-mirror.com

huggingface-cli login --token $HUGGINGFACE_TOKEN --add-to-git-credential
```

注意：此命令为自动下载评估数据所需。


```bash
accelerate launch --num_processes=8 \
  -m lmms_eval \
  --model llava \
  --model_args pretrained=/path/to/llama3-llava-next-8b,conv_template=llava_llama_3 \
  --tasks ai2d,chartqa,docvqa_val,mme,mmbench_en_dev \
  --batch_size 1 \
  --log_samples \
  --log_samples_suffix llava_next \
  --output_path ./logs/
```

```bash
accelerate launch --num_processes=1 \
  -m lmms_eval \
  --model llava \
  --model_args pretrained=/path/to/llava-next-72b,conv_template=qwen_1_5,model_name=llava_qwen,device_map=auto \
  --tasks ai2d,chartqa,docvqa_val,mme,mmbench_en_dev \
  --batch_size 1 \
  --log_samples \
  --log_samples_suffix llava_next \
  --output_path ./logs/
```

## result

![alt text](readme_imgs/multimodal-8b.png)

### 精度

无

## 应用场景

参考[README.md](../README.md)

## 预训练权重

|model|url|
|:---:|:---:|
|llama3-llava-next-8b|[hf](https://huggingface.co/lmms-lab/llama3-llava-next-8b) \| [SCNet](http://113.200.138.88:18080/aimodels/lmms-lab/llama3-llava-next-8b.git) |
|llava-next-qwen-32b|[hf](https://huggingface.co/lmms-lab/llava-next-qwen-32b) \| [SCNet](http://113.200.138.88:18080/aimodels/lmms-lab/llava-next-qwen-32b.git) |

模型下载后保存至`ckpts`（需自行创建）.

## 源码仓库及问题反馈

参考[README.md](../README.md)

## 参考资料

* https://github.com/LLaVA-VL/LLaVA-NeXT/blob/main/docs/LLaVA-NeXT.md
* https://llava-vl.github.io/blog/2024-05-10-llava-next-stronger-llms/
