import sys
import os
import argparse
import collections
import torch

tencentpretrain_dir = os.path.abspath(os.path.join(os.path.dirname(__file__), ".."))
sys.path.insert(0, tencentpretrain_dir)

from scripts.convert_bart_from_huggingface_to_tencentpretrain import \
    convert_encoder_decoder_transformer_from_huggingface_to_tencentpretrain


parser = argparse.ArgumentParser(formatter_class=argparse.ArgumentDefaultsHelpFormatter)
parser.add_argument("--input_model_path", type=str, default="models/input_model.bin",
                    help=".")
parser.add_argument("--output_model_path", type=str, default="models/output_model.bin",
                    help=".")
parser.add_argument("--layers_num", type=int, default=6, help=".")
parser.add_argument("--decoder_layers_num", type=int, default=6, help=".")

args = parser.parse_args()

input_model = torch.load(args.input_model_path, map_location="cpu")

output_model = collections.OrderedDict()

output_model["embedding.sinusoidalpos.pe"] = input_model["model.encoder.embed_positions.weight"].unsqueeze(1)
output_model["tgt_embedding.sinusoidalpos.pe"] = input_model["model.decoder.embed_positions.weight"].unsqueeze(1)
output_model["embedding.word.embedding.weight"] = input_model["model.encoder.embed_tokens.weight"]
output_model["tgt_embedding.word.embedding.weight"] = input_model["model.decoder.embed_tokens.weight"]
output_model["target.lm.output_layer.weight"] = input_model["lm_head.weight"]
output_model["target.lm.output_layer.bias"] = input_model["final_logits_bias"].squeeze(0)

convert_encoder_decoder_transformer_from_huggingface_to_tencentpretrain(input_model, output_model, args.layers_num, args.decoder_layers_num)

output_model["encoder.layer_norm.gamma"] = input_model["model.encoder.layer_norm.weight"]
output_model["encoder.layer_norm.beta"] = input_model["model.encoder.layer_norm.bias"]
output_model["decoder.layer_norm.gamma"] = input_model["model.decoder.layer_norm.weight"]
output_model["decoder.layer_norm.beta"] = input_model["model.decoder.layer_norm.bias"]

torch.save(output_model, args.output_model_path)
