简体中文 | [English](README_en.md)

# 信息抽取应用

**目录**
- [1. 信息抽取应用简介](#1)
- [2. 技术特色](#2)
  - [2.1 信息抽取方案全覆盖](#21)
  - [2.2 强大的训练基座](#22)
  - [2.3 产业级全流程方案](#23)
  - [2.4 效果展示](#24)
- [3. 快速开始](#快速开始)
  - [3.1 Taskflow开箱即用](#31)
  - [3.2 文本信息抽取](#32)
  - [3.3 文档信息抽取](#33)

<a name="1"></a>

## 1. 信息抽取应用简介

信息抽取应用针对信息抽取一系列高频场景开源了产业级解决方案，**具备多领域、多任务、跨模态的能力**，打通**数据标注-模型训练-模型调优-预测部署全流程**，可快速实现信息抽取产品落地。

信息抽取通俗地说就是从给定的文本/图片等输入数据中抽取出结构化信息的过程。在信息抽取的落地过程中通常面临领域多变、任务多样、数据稀缺等许多挑战。针对信息抽取领域的难点和痛点，PaddleNLP信息抽取应用**基于UIE统一建模的思想**，提供了信息抽取产业级应用方案，**除支持纯文本场景实体、关系、事件、观点等不同任务抽取外，还支持文档/图片/表格的端到端信息抽取**。该应用**不限定行业领域和抽取目标**，可实现从产品原型研发、业务POC阶段到业务落地、迭代阶段的无缝衔接，助力开发者实现特定领域抽取场景的快速适配与落地。

**信息抽取应用亮点：**

- **覆盖场景全面🎓：** 覆盖信息抽取各类主流任务，面向纯文本和文档场景，支持多语言，满足开发者多样信息抽取落地需求。
- **效果领先🏃：** 以在纯文本、多模态上均有突出效果的UIE系列模型作为训练基座，提供多种尺寸的预训练模型满足不同需求，具有广泛成熟的实践应用性。
- **简单易用⚡：** 通过Taskflow实现三行代码可实现无标注数据的情况下进行快速调用，一行命令即可开启信息抽取训练，轻松完成部署上线，降低信息抽取技术落地门槛。
- **高效调优✊：** 开发者无需机器学习背景知识，即可轻松上手数据标注及模型训练流程。

<a name="2"></a>

## 2. 技术特色

<a name="21"></a>

### 2.1 信息抽取方案全覆盖

多模型选择，满足精度、速度，适配不同信息抽取使用场景。

|                           模型名称                           | 使用场景                                                   | 支持任务                                             |
| :----------------------------------------------------------: | :--------------------------------------------------------- | :--------------------------------------------------- |
| `uie-base`<br />`uie-medium`<br />`uie-mini`<br />`uie-micro`<br />`uie-nano` | 面向**纯文本**场景的**抽取式**模型，支持**中文**         | 具备实体、关系、事件、评论观点等通用信息抽取能力 |
|                       `uie-base-en`                          | 面向**纯文本**场景的**抽取式**模型，支持**英文**         | 具备实体、关系、事件、评论观点等通用信息抽取能力 |
|                     `uie-m-base`<br />`uie-m-large`          | 面向**纯文本**场景的**抽取式**模型，支持**中英**         | 具备实体、关系、事件、评论观点等通用信息抽取能力 |
|                      <b>`uie-x-base`</b>                     | 面向**纯文本**和**文档**场景的**抽取式**模型，支持**中英** | 支持纯文本场景的全部功能，还支持文档/图片/表格的端到端信息抽取 |

<a name="22"></a>

### 2.2 强大的训练基座

信息抽取应用使用ERNIE 3.0轻量级模型作为预训练模型，同时在大量信息抽取数据上进行了二次预训练，从而让模型适配固定prompt。

- 中文文本数据集实验效果

我们在互联网、医疗、金融三大垂类文本自建测试集上进行了实验：

<table>
<tr><th row_span='2'><th colspan='2'>金融<th colspan='2'>医疗<th colspan='2'>互联网
<tr><td><th>0-shot<th>5-shot<th>0-shot<th>5-shot<th>0-shot<th>5-shot
<tr><td>uie-base (12L768H)<td>46.43<td>70.92<td><b>71.83</b><td>85.72<td>78.33<td>81.86
<tr><td>uie-medium (6L768H)<td>41.11<td>64.53<td>65.40<td>75.72<td>78.32<td>79.68
<tr><td>uie-mini (6L384H)<td>37.04<td>64.65<td>60.50<td>78.36<td>72.09<td>76.38
<tr><td>uie-micro (4L384H)<td>37.53<td>62.11<td>57.04<td>75.92<td>66.00<td>70.22
<tr><td>uie-nano (4L312H)<td>38.94<td>66.83<td>48.29<td>76.74<td>62.86<td>72.35
<tr><td>uie-m-large (24L1024H)<td><b>49.35</b><td><b>74.55</b><td>70.50<td><b>92.66</b><td>78.49<td><b>83.02</b>
<tr><td>uie-m-base (12L768H)<td>38.46<td>74.31<td>63.37<td>87.32<td>76.27<td>80.13
<tr><td>🧾 🎓<b>uie-x-base (12L768H)</b><td>48.84<td>73.87<td>65.60<td>88.81<td><b>79.36</b><td>81.65
</table>

0-shot表示无训练数据直接通过```paddlenlp.Taskflow```进行预测，5-shot表示每个类别包含5条标注数据进行模型微调。**实验表明UIE在垂类场景可以通过少量数据（few-shot）进一步提升效果**。

- 多模态数据集实验效果

我们在通用、金融、医疗三大场景自建多模态测试集上对UIE-X的零样本效果进行了实验：

<table>
<tr><th ><th>通用<th>金融<th colspan='2'>医疗
<tr><td>🧾 🎓<b>uie-x-base (12L768H)</b><td>65.03<td>73.51<td>84.24
</table>

通用测试集包含了不同领域的复杂样本，抽取难度最大。

<a name="23"></a>

### 2.3 产业级全流程方案

**调研阶段**

- 该阶段目标需求开放且缺少数据积累。我们提供Taskflow三行代码极简调用的方式，无需标注数据即可在业务场景上快速验证效果。
  - [文本抽取 Taskflow使用指南](./taskflow_text.md)
  - [文档抽取 Taskflow使用指南](./taskflow_doc.md)

**数据准备阶段**

- 我们推荐在实际的业务场景中定制自己的信息抽取模型。我们提供了不同抽取场景的Label Studio标注解决方案，可基于该方案实现从数据标注到训练数据构造的无缝衔接，大大降低了数据标注、模型定制的时间成本。
  - [文本抽取标注指南](./label_studio_text.md)
  - [文档抽取标注指南](./label_studio_doc.md)。

**模型微调及封闭域蒸馏**

- 基于UIE优秀的小样本微调能力，实现低成本模型定制适配。同时提供封闭域蒸馏的加速方案，解决抽取速度慢的问题。
  - [文本信息抽取全流程示例](./text/README.md)
  - [文档信息抽取全流程示例](./document/README.md)

**模型部署**

- 提供HTTP部署方案，快速实现定制模型的部署上线。
  - [文本抽取HTTP部署指南](./text/deploy/simple_serving/README.md)
  - [文档抽取HTTP部署指南](./document/deploy/simple_serving/README.md)

<a name="24"></a>

### 2.4 效果展示

- 🧾 通过[Huggingface网页](https://huggingface.co/spaces/PaddlePaddle/UIE-X)体验UIE-X功能：

<div align="center">
    <img src=https://user-images.githubusercontent.com/40840292/207856955-a01cd5dd-fd5c-48ae-b8fd-c69512a88845.png height=500 width=900 hspace='10'/>
</div>

- UIE-X端到端文档抽取产业应用示例

  - 报关单

    <div align="center">
        <img src=https://user-images.githubusercontent.com/40840292/205879840-239ada90-1692-40e4-a17f-c5e963fdd204.png height=800 width=500 />
    </div>

  - Delivery Note（需微调）

    <div align="center">
        <img src=https://user-images.githubusercontent.com/40840292/205922422-f2615050-83cb-4bf5-8887-461f5633e85c.png height=250 width=700 />
    </div>

  - 增值税发票（需微调）

    <div align="center">
        <img src=https://user-images.githubusercontent.com/40840292/206084942-44ba477c-9244-4ce2-bbb5-ba430c9b926e.png height=550 width=700 />
    </div>

  - 表单（需微调）

    <div align="center">
        <img src=https://user-images.githubusercontent.com/40840292/207856330-7aa0d158-47e0-477f-a88f-e23a040504a3.png height=400 width=700 />
    </div>

<a name="3"></a>

## 3. 快速开始

<a name="31"></a>

### 3.1 Taskflow开箱即用

- 通过Taskflow实现开箱即用
  👉 [文本抽取 Taskflow使用指南](./taskflow_text.md)
  👉 [文档抽取 Taskflow使用指南](./taskflow_doc.md)

<a name="32"></a>

### 3.2 文本信息抽取

- 快速开启文本信息抽取 👉 [文本信息抽取指南](./text/README.md)

<a name="33"></a>

### 3.3 文档信息抽取

- 快速开启文档信息抽取 👉 [文档信息抽取指南](./document/README.md)
