/* Copyright (c) 2022 PaddlePaddle Authors. All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License. */

#include "fast_tokenizer/pretokenizers/whitespace_and_punctuation.h"

#include "fast_tokenizer/normalizers/normalizer.h"
#include "re2/re2.h"

namespace paddlenlp {
namespace fast_tokenizer {
namespace pretokenizers {
static re2::RE2 pattern("[\\s\\p{Zs}]+");

void WhitespaceAndPunctuationPreTokenizer::operator()(
    PreTokenizedString* pretokenized) const {
  pretokenized->Split([&](int idx,
                          normalizers::NormalizedString* normalized,
                          std::vector<StringSplit>* string_splits) {
    std::vector<normalizers::NormalizedString> normalized_splits;
    normalized->Split(pattern, core::SplitMode::REMOVED, &normalized_splits);
    for (auto& normalize : normalized_splits) {
      string_splits->push_back(StringSplit(normalize));
    }
  });
  pretokenized->Split([&](int idx,
                          normalizers::NormalizedString* normalized,
                          std::vector<StringSplit>* string_splits) {
    std::vector<normalizers::NormalizedString> normalized_splits;
    normalized->Split("\\w+", core::SplitMode::ISOLATED, &normalized_splits);
    for (auto& normalize : normalized_splits) {
      string_splits->push_back(StringSplit(normalize));
    }
  });
}

void to_json(
    nlohmann::json& j,
    const WhitespaceAndPunctuationPreTokenizer& whitespace_pretokenizer) {
  j = {
      {"type", "WhitespaceAndPunctuationPreTokenizer"},
  };
}

void from_json(const nlohmann::json& j,
               WhitespaceAndPunctuationPreTokenizer& whitespace_pretokenizer) {}

}  // namespace pretokenizers
}  // namespace fast_tokenizer
}  // namespace paddlenlp
