# 基于TencentPretrain的LLaMa推理

## 模型介绍

```
LLaMA，这是一个基础语言模型的集合，参数范围从7B到65B。在数万亿的tokens上训练出的模型，并表明可以专门使用公开可用的数据集来训练最先进的模型，而不依赖于专有的和不可访问的数据集。
```

## 模型结构

```
LLAMA网络基于 Transformer 架构。提出了各种改进，并用于不同的模型，例如 PaLM。以下是与原始架构的主要区别：
预归一化。为了提高训练稳定性，对每个transformer 子层的输入进行归一化，而不是对输出进行归一化。使用 RMSNorm 归一化函数。
SwiGLU 激活函数 [PaLM]。使用 SwiGLU 激活函数替换 ReLU 非线性以提高性能。使用 2 /3 4d 的维度而不是 PaLM 中的 4d。
旋转嵌入。移除了绝对位置嵌入，而是添加了旋转位置嵌入 (RoPE)，在网络的每一层。
```

以下是llama-7B的主要网络参数配置：

```
  "hidden_act": "silu",
  "hidden_size": 4096,
  "initializer_range": 0.02,
  "intermediate_size": 11008,
  "max_position_embeddings": 2048,
  "model_type": "llama",
  "num_attention_heads": 32,
  "num_hidden_layers": 32,
  "rms_norm_eps": 1e-06,
  "vocab_size": 32000
```

# LLAMA推理

## 环境配置

推荐使用docker方式运行，提供[光源](https://www.sourcefind.cn/)拉取的docker镜像：

```
docker pull image.sourcefind.cn:5000/dcu/admin/base/vscode-pytorch:1.10.0-centos7.6-dtk-22.10-py37-latest
```

安装docker中没有的依赖

```
pip install tensor_parallel==1.2.5 --no-dependencies
pip install transformers==4.28.1 sentencepiece==0.1.99
```

## 模型下载地址

[llama chat 7B](https://huggingface.co/Linly-AI/ChatFlow-7B)

[llama caht 13b](https://huggingface.co/Linly-AI/ChatFlow-13B)

## 参数说明

```
--load_model_path （必填项），预训练好的模型，默认是fp16的（如果需要fp32，修改llama_infer.py的L41为对应的精度）
--test_path （必填项），输入的prompts，每一行是一个prompts。
--prediction_path （必填项），输出结果保存的路径。
--config_path （必填项），模型参数配置文件，可以保存在config文件夹中。
--spm_model_path （必填项），模型tokenizer存放的路径。
--batch_size （可选），默认为1。批处理大小，注意按需使用，因为attention cache会根据这个大小来构造tensor并且保存在显存中。
--seq_length （可选），默认为128。生成句子的总长度，等于prompts + 模型生成的长度。
--world_size （可选），默认为1。使用多少张卡进行张量并行推理。
--use_int8 （可选），默认为False。是否使用int8推理。
--top_k （可选），默认为40。句子的生成会针对top_k做采样，影响生成多样性。
--top_p （可选），默认为0.95。句子的生成会针对累积概率top_p做采样，影响生成多样性。
--temperature （可选），默认为0.8。对最后的probabilities做一次放缩，影响token采样结果。
--repetition_penalty_range （可选），默认为1024。重复出现token的惩罚范围。
--repetition_penalty_slope （可选），默认为0。重复出现token的惩罚slope。
--repetition_penalty （可选），默认为1.15。重复出现token的惩罚系数。
```

## 单卡推理

```
./run.sh
export HIP_VISIBLE_DEVICES=0   指定使用第0号卡
LOAD_MODEL  为下载的llama 模型bin路径
SPM_PATH	为下载的llama 模型tokenizer路径
--config_path 需要与使用的模型对齐，若使用13b的模型，这里需要改成config/llama_13b_config.json
```

## 多张卡并行推理

```
./run-tp.sh
export HIP_VISIBLE_DEVICES=0,1,2,3   指定使用第0,1,2,3号卡
LOAD_MODEL  为下载的llama 模型bin路径
SPM_PATH	为下载的llama 模型tokenizer路径
--config_path 需要与使用的模型对齐，若使用13b的模型，这里需要改成config/llama_13b_config.json
```

## 多轮对话

```
./run-dialogue.sh
#对话时输入  clear  清空聊天历史  输入 exit  退出程序
export HIP_VISIBLE_DEVICES=0,1,2,3   指定使用第0,1,2,3号卡
LOAD_MODEL  为下载的llama 模型bin路径
SPM_PATH	为下载的llama 模型tokenizer路径
--config_path 需要与使用的模型对齐，若使用13b的模型，这里需要改成config/llama_13b_config.json
```

## 多轮对话推理效果

![image-llama](./doc/llama-inf.jpg)

## 源码仓库及问题反馈

https://developer.hpccube.com/codes/hepj/llama_pytorch

## 参考

https://github.com/ProjectD-AI/llama_inference