/*
 * Copyright (c) 2019-2023, NVIDIA CORPORATION.  All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#pragma once

#include "src/fastertransformer/layers/DenseWeight.h"

namespace fastertransformer {

template<typename T>
struct XlnetAttentionWeight {
    T* attr_kernel_Q;
    T* attr_kernel_K;
    T* attr_kernel_V;
    T* attr_bias_Q_w;
    T* attr_bias_Q_r;
    T* attr_bias_Q_s;

    T* attr_pos_emb;
    T* attr_seg_embed;
    T* attr_proj_o;
};

}  // namespace fastertransformer
