// Ignore CUTLASS warnings about type punning
#include "src/fastertransformer/kernels/ck_kernels/kernels.h"
#include "src/fastertransformer/kernels/ck_kernels/moe_gemm/moe_gemm_kernels.h"
#include "src/fastertransformer/ck_extensions/include/ck_extensions/ck_utils.h"
#include "src/fastertransformer/utils/logger.h"
#include <math.h>
#include <sstream>
#include "hip/hip_runtime.h"

namespace fastertransformer {
template<typename T, typename WeightType>
MoeGemmRunner<T, WeightType>::MoeGemmRunner()
{
    FT_LOG_DEBUG(__PRETTY_FUNCTION__);
    int device{-1};
    check_hip_error(hipGetDevice(&device));
    sm_ = getSMVersion();
    check_hip_error(hipDeviceGetAttribute(&multi_processor_count_, hipDeviceAttributeMultiprocessorCount, device));
}

template<typename T, typename WeightType>
void MoeGemmRunner<T, WeightType>::moe_gemm_bias_act(const T*          A,
                                                     const WeightType* B,
                                                     const T*          weight_scales,
                                                     const T*          biases,
                                                     T*                C,
                                                     int64_t*          total_rows_before_expert,
                                                     int64_t           total_rows,
                                                     int64_t           gemm_n,
                                                     int64_t           gemm_k,
                                                     int               num_experts,
                                                     ActivationType    activation_type
                                                     )
                                                    //  hipStream_t      stream)
{
    FT_LOG_DEBUG(__PRETTY_FUNCTION__);
}

template<typename T, typename WeightType>
void MoeGemmRunner<T, WeightType>::moe_gemm(const T*          A,
                                            const WeightType* B,
                                            const T*          weight_scales,
                                            T*                C,
                                            int64_t*          total_rows_before_expert,
                                            int64_t           total_rows,
                                            int64_t           gemm_n,
                                            int64_t           gemm_k,
                                            int               num_experts
                                            )
                                            // hipStream_t      stream)
{
    FT_LOG_DEBUG(__PRETTY_FUNCTION__);

}

}  // namespace fastertransformer