#pragma once

#include "ck/utility/sequence.hpp"
#include "hip/hip_runtime.h"

namespace fastertransformer {

static const char* _hipGetErrorEnum(hipError_t error)
{
    return hipGetErrorString(error);
}

template<typename T>
void check(T result, char const* const func, const char* const file, int const line)
{
    if (result) {
        throw std::runtime_error(std::string("[FT][ERROR] CUDA runtime error: ") + (_hipGetErrorEnum(result)) + " "
                                 + file + ":" + std::to_string(line) + " \n");
    }
}

#define check_hip_error(val) check((val), #val, __FILE__, __LINE__)
#define check_hip_error_2(val, file, line) check((val), #val, file, line)

inline int getSMVersion()
{
    int device{-1};
    check_hip_error(hipGetDevice(&device));
    int sm_major = 0;
    int sm_minor = 0;
    check_hip_error(hipDeviceGetAttribute(&sm_major, hipDeviceAttributeComputeCapabilityMinor, device));
    check_hip_error(hipDeviceGetAttribute(&sm_minor, hipDeviceAttributeComputeCapabilityMinor, device));
    return sm_major * 10 + sm_minor;
}


}
