#!/bin/bash

export ROCM_PATH=/opt/dtk-22.10.1
export ROCM_SOURCE_DIR=${ROCM_PATH}
echo $ROCM_PATH
export HIP_PATH=${ROCM_PATH}/hip
export AMDGPU_TARGETS="gfx900;gfx906"
export PATH=${ROCM_PATH}/bin:${ROCM_PATH}/llvm/bin:${ROCM_PATH}/hcc/bin:${ROCM_PATH}/hip/bin:$PATH

export LD_LIBRARY_PATH=${ROCM_PATH}/lib:${ROCM_PATH}/lib64:$LD_LIBRARY_PATH
export LD_LIBRARY_PATH=${ROCM_PATH}/hip/lib:${ROCM_PATH}/llvm/lib:${ROCM_PATH}/opencl/lib/x86_64:$LD_LIBRARY_PATH
export C_INCLUDE_PATH=${ROCM_PATH}/include:${ROCM_PATH}/hip/include/hip:${ROCM_PATH}/llvm/include:/opencl/include:${ROCM_PATH}/include/rocrand:${ROCM_PATH}/include/hiprand
export CPLUS_INCLUDE_PATH=${ROCM_PATH}/include:${ROCM_PATH}/hip/include/hip:${ROCM_PATH}/llvm/include:/opencl/include:${ROCM_PATH}/include/rocrand:${ROCM_PATH}/include/hiprand
export PATH=${ROCM_PATH}/miopen/bin:${ROCM_PATH}/rocblas/bin:${ROCM_PATH}/hipsparse/bin:$PATH
export LD_LIBRARY_PATH=${ROCM_PATH}/miopen/lib:${ROCM_PATH}/rocblas/lib:$LD_LIBRARY_PATH
export MIOPEN_SYSTEM_DB_PATH=${ROCM_PATH}/miopen/share/miopen/db/
export LD_LIBRARY_PATH=/usr/lib64:$LD_LIBRARY_PATH
export LIBRARY_PATH=/usr/lib64:$LIBRARY_PATH

export RCCL_PATH=$ROCM_PATH/rccl
export NCCL_PATH=$ROCM_PATH/rccl
export LD_LIBRARY_PATH=$RCCL_PATH/lib:$LD_LIBRARY_PATH

export MIOPEN_FIND_MODE=3
export HSA_FORCE_FINE_GRAIN_PCIE=1
export NCCL_P2P_LEVEL=5

export NCCL_GDR_FLUSH_DISABLE=1
export NCCL_NET_GDR_LEVEL=SYS
export RCCL_NCHANNELS=2

export NCCL_DEBUG=INFO
export MODEL_SIZE=13
export SEQ_LEN=2048
export GC_SCALE=4
export DATE=20230322
export USE_FLASH_ATTN=0

#export HIP_LOG_LEVEL=5
#export HIP_MODULE_MASK=0xffffffff
#export HIP_MEMORY_BLOCKING=1
#export HIP_LAUNCH_BLOCKING=1

export HIP_CLANG_PATH=/opt/dtk-22.10.1/llvm/bin

export HSA_PATH=/opt/dtk-22.10.1/hsa
export AOMP=/opt/dtk-22.10.1/llvm
export LD_LIBRARY_PATH=/opt/dtk-22.10.1/rccl/lib:/usr/lib64:/opt/dtk-22.10.1/miopen/lib:/opt/dtk-22.10.1/rocblas/lib:/opt/dtk-22.10.1/hip/lib:/opt/dtk-22.10.1/llvm/lib:/opt/dtk-22.10.1/opencl/lib/x86_64:/opt/dtk-22.10.1/lib:/opt/dtk-22.10.1/lib64:/opt/dtk-22.10.1/rccl/lib:/usr/lib64:/opt/dtk-22.10.1/miopen/lib:/opt/dtk-22.10.1/rocblas/lib:/opt/dtk-22.10.1/hip/lib:/opt/dtk-22.10.1/llvm/lib:/opt/dtk-22.10.1/opencl/lib/x86_64:/opt/dtk-22.10.1/lib:/opt/dtk-22.10.1/lib64:/opt/dtk-22.10.1/roctracer/lib:/opt/dtk-22.10.1/rocthrust/lib:/opt/dtk-22.10.1/rocsparse/lib:/opt/dtk-22.10.1/rocsolver/lib:/opt/dtk-22.10.1/rocrand/lib:/opt/dtk-22.10.1/rocprofiler/lib:/opt/dtk-22.10.1/rocprim/lib:/opt/dtk-22.10.1/dtk-22.10.1_smi/lib:/opt/dtk-22.10.1/rocfft/lib:/opt/dtk-22.10.1/rocblas/lib:/opt/dtk-22.10.1/rocalution/lib:/opt/dtk-22.10.1/rccl/lib:/opt/dtk-22.10.1/opencl/lib:/opt/dtk-22.10.1/oam/lib:/opt/dtk-22.10.1/migraphx/lib:/opt/dtk-22.10.1/miopengemm/lib:/opt/dtk-22.10.1/miopen/lib:/opt/dtk-22.10.1/llvm/lib-debug/src/openmp/libomptarget/plugins/remote/lib:/opt/dtk-22.10.1/llvm/lib/clang/14.0.0/lib:/opt/dtk-22.10.1/llvm/lib:/opt/dtk-22.10.1/hsa/lib:/opt/dtk-22.10.1/hipsparse/lib:/opt/dtk-22.10.1/hipsolver/lib:/opt/dtk-22.10.1/hiprand/lib:/opt/dtk-22.10.1/hipfft/lib:/opt/dtk-22.10.1/hipcub/lib:/opt/dtk-22.10.1/hipblas-clients/lib:/opt/dtk-22.10.1/hipblas/lib:/opt/dtk-22.10.1/hip/lib:/opt/dtk-22.10.1/lib:/opt/dtk-22.10.1/lib64:/opt/mpi/lib:/usr/local/lib/:/usr/local/lib64/:/usr/lib64/
export PATH=/opt/dtk-22.10.1/miopen/bin:/opt/dtk-22.10.1/rocblas/bin:/opt/dtk-22.10.1/hipsparse/bin:/opt/dtk-22.10.1/bin:/opt/dtk-22.10.1/llvm/bin:/opt/dtk-22.10.1/hcc/bin:/opt/dtk-22.10.1/hip/bin:/opt/dtk-22.10.1/miopen/bin:/opt/dtk-22.10.1/rocblas/bin:/opt/dtk-22.10.1/hipsparse/bin:/opt/dtk-22.10.1/bin:/opt/dtk-22.10.1/llvm/bin:/opt/dtk-22.10.1/hcc/bin:/opt/dtk-22.10.1/hip/bin:/opt/dtk-22.10.1/libexec/rocprofiler:/opt/dtk-22.10.1/libexec/dtk-22.10.1_smi:/opt/dtk-22.10.1/rocprofiler/bin:/opt/dtk-22.10.1/opencl/bin:/opt/dtk-22.10.1/miopen/bin:/opt/dtk-22.10.1/llvm/lib/clang/14.0.0/bin:/opt/dtk-22.10.1/llvm/bin:/opt/dtk-22.10.1/hip/bin:/opt/dtk-22.10.1/bin:/opt/mpi/bin:/root/anaconda3/bin:/root/anaconda3/condabin:/usr/lib64/qt-3.3/bin:/root/perl5/bin:/opt/dtk-22.10.1/bin:/opt/dtk-22.10.1/hip/bin:/opt/dtk-22.10.1/llvm/bin:/opt/dtk-22.10.1/llvm/lib/clang/14.0.0/bin:/opt/dtk-22.10.1/miopen/bin:/opt/dtk-22.10.1/opencl/bin:/opt/dtk-22.10.1/rocprofiler/bin:/opt/dtk-22.10.1/libexec/dtk-22.10.1_smi:/opt/dtk-22.10.1/libexec/rocprofiler:/opt/rh/devtoolset-7/root/usr/bin:/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/root/bin
export ROCM_ROOT=/opt/dtk-22.10.1
export ROCBLAS_TENSILE_LIBPATH=/opt/dtk-22.10.1/lib/rocblas/library
export HIP_ROCCLR_HOME=/opt/dtk-22.10.1/hip
export HIP_LIB_PATH=/opt/dtk-22.10.1/hip/lib
export DEVICE_LIB_PATH=/opt/dtk-22.10.1/amdgcn/bitcode

#export ROCBLAS_LAYER=3

