#!/bin/bash
export HSA_FORCE_FINE_GRAIN_PCIE=1

export NCCL_IB_DISABLE=1
export NCCL_SOCKET_IFNAME=ens38f0

# LoRA + 多机多卡 0
CUDA_VISIBLE_DEVICES=0,1,2,3,4,5,6,7 accelerate launch \
    --config_file ./master_config.yaml \
    --machine_rank 0 \
    ../../src/train_bash.py \
    --stage sft \
    --do_train \
    --model_name_or_path meta-llama/Meta-Llama-3-70B-Instruct \
    --dataset alpaca_zh \
    --dataset_dir ../../data \
    --template llama3 \
    --finetuning_type lora \
    --lora_target q_proj,v_proj \
    --output_dir saves/LLaMA3-70B/lora/sft \
    --overwrite_cache \
    --overwrite_output_dir \
    --cutoff_len 8192 \
    --preprocessing_num_workers 1 \
    --per_device_train_batch_size 1 \
    --per_device_eval_batch_size 1 \
    --gradient_accumulation_steps 2 \
    --lr_scheduler_type cosine \
    --logging_steps 10 \
    --warmup_steps 20 \
    --save_steps 100 \
    --eval_steps 100 \
    --evaluation_strategy steps \
    --load_best_model_at_end \
    --learning_rate 5e-5 \
    --num_train_epochs 3.0 \
    --max_samples 1000 \
    --val_size 0.1 \
    --ddp_timeout 180000000 \
    --plot_loss \
    --fp16
