#!/bin/bash
export HSA_FORCE_FINE_GRAIN_PCIE=1

MASTER_ADDR=''

# 多机多卡+deepspeed
deepspeed --hostfile=/path/of/hostfile \
    --num_nodes 2 \
    --master_addr $MASTER_ADDR \
    --master_port 12345 \
    ../../src/train_bash.py \
    --deepspeed ../deepspeed/ds_z3_config.json \
    --stage sft \
    --do_train \
    --model_name_or_path meta-llama/Meta-Llama-3-70B-Instruct \
    --dataset alpaca_zh \
    --dataset_dir ../../data \
    --template llama3 \
    --finetuning_type full \
    --output_dir saves/LLaMA3-70B-Instruct/full/sft \
    --overwrite_cache \
    --overwrite_output_dir \
    --cutoff_len 8192 \
    --preprocessing_num_workers 16 \
    --per_device_train_batch_size 1 \
    --per_device_eval_batch_size 1 \
    --gradient_accumulation_steps 8 \
    --lr_scheduler_type cosine \
    --logging_steps 10 \
    --warmup_steps 20 \
    --save_steps 500 \
    --eval_steps 100 \
    --evaluation_strategy steps \
    --learning_rate 5e-5 \
    --num_train_epochs 3.0 \
    --max_samples 3000 \
    --val_size 0.1 \
    --ddp_timeout 180000000 \
    --plot_loss \
    --fp16
