# llama3
## 论文
[llama3](https://llama.meta.com/llama3/)

## 模型结构
Llama-3中选择了一个相对标准的decoder-only的transformer架构。与Llama-2相比，做了几个关键的改进:
- 基于超过15T token训练数据，大小相当于Llama 2数据集的7倍还多，增强了推理、代码生成和指令跟随等方面的能力；
- 支持8K长文本（之前是4k），改进的tokenizer具有128K tokens的词汇量，可以更有效地对语言进行编码，从而大大提高了模型的性能；
- 采用分组查询注意力（grouped query attention，GQA）、掩码等技术，帮助开发者以最低的能耗获取绝佳的性能。
- 在8,192个tokens的序列上训练模型，使用掩码来确保self-attention不会跨越文档边界。

## 算法原理

<div align=center>
    <img src="./doc/method.png"/>
</div>

## 环境配置
-v 路径、docker_name和imageID根据实际情况修改
**注意**：bitsandbytes库功能不全，暂不支持4bits

### Docker（方法一）

```bash
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.1.0-ubuntu22.04-dtk23.10.1-py310
docker run -it -v /path/your_code_data/:/path/your_code_data/ -v /opt/hyhal/:/opt/hyhal/:ro --shm-size=32G --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name docker_name imageID bash

cd /your_code_path/llama3_pytorch

pip install -e .

pip install deepspeed-0.12.3+gitfe61783.abi0.dtk2310.torch2.1.0a0-cp310-cp310-manylinux2014_x86_64.whl
pip install bitsandbytes-0.43.0-py3-none-any.whl
pip install -U xtuner # 0.1.18
pip install mmengine==0.10.3
```

### Dockerfile（方法二）

```bash
cd docker
docker build --no-cache -t llama3:latest .
docker run -it -v /path/your_code_data/:/path/your_code_data/ -v /opt/hyhal/:/opt/hyhal/:ro --shm-size=32G --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name docker_name imageID bash

cd /your_code_path/llama3_pytorch

pip install -e .

pip install deepspeed-0.12.3+gitfe61783.abi0.dtk2310.torch2.1.0a0-cp310-cp310-manylinux2014_x86_64.whl
pip install bitsandbytes-0.43.0-py3-none-any.whl
pip install -U xtuner # 0.1.18
pip install mmengine==0.10.3
```

### Anaconda（方法三）
关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.hpccube.com/tool/)开发者社区下载安装。
```bash
DTK驱动: dtk23.10.1
python: python3.10
torch: 2.1.0
xtuner: 0.1.18
```
`Tips：以上dtk驱动、python、torch等DCU相关工具版本需要严格一一对应`

其它非深度学习库安装方式如下：
```bash
pip install -e .

pip install deepspeed-0.12.3+gitfe61783.abi0.dtk2310.torch2.1.0a0-cp310-cp310-manylinux2014_x86_64.whl
pip install bitsandbytes-0.43.0-py3-none-any.whl
pip install -U xtuner # 0.1.18
pip install mmengine==0.10.3
```

## 数据集
```
├── llama3_pytorch
│   ├── datasets
│       ├── alpaca_data.json
│       └── multi_turn_dataset_2.json
```

## 训练
### xtuner微调方法
1. 下载预训练模型，具体模型请修改 `download_models.py`
```bash
cd /your_code_path/llama3_pytorch
pip install modelscope
python download_models.py
mv ~/.cache/modelscope/hub/LLM-Research ./
```
2. 修改[llama3_8b_instruct_qlora_alpaca_e3_M.py](./llama3_8b_instruct_qlora_alpaca_e3_M.py)代码中的`pretrained_model_name_or_path`、`data_path`为本地对应数据地址；
3. 根据硬件环境和自身训练需求来调整 `max_length`、`batch_size`、`accumulative_counts`、`max_epochs`、`lr`、`save_steps`、`evaluation_freq`、model.lora中的`r`、`lora_alpha`参数，默认参数支持4*32G；
4. ${DCU_NUM}参数修改为要使用的DCU卡数量，不同数据集需要修改llama3_8b_instruct_qlora_alpaca_e3_M.py中`SYSTEM`、`evaluation_inputs`、`dataset_map_fn`、`train_dataloader.sampler`、`train_cfg`参数设置，详情请参考代码注释项，当前默认alpaca数据集。
5. 执行
```bash
bash finetune.sh
or
NPROC_PER_NODE=${DCU_NUM} xtuner train ./llama3_8b_instruct_qlora_alpaca_e3_M.py --deepspeed deepspeed_zero2
```

## 推理
预训练模型下载方法请参考下面的[预训练权重](#预训练权重)章节，不同的模型需要不同的模型并行(MP)值，如下表所示:

|  Model | MP |
|--------|----|
| 8B     | 1  |
| 70B    | 8  |

所有模型都支持序列长度高达8192个tokens，但我们根据max_seq_len和max_batch_size值预先分配缓存。根据你的硬件设置。

**Tips:**
- `–nproc_per_node`需要根据模型的MP值进行设置（参考上表）。
- `max_seq_len`和`max_batch_size`参数按需设置。

### Pretrained模型
这些模型都没有针对聊天或者Q&A进行微调。可以参考`example_text_completion.py`里的用例。

- Meta-Llama-3-8B 模型示例，Meta-Llama-3-70B模型仅需替换--ckpt_dir、--tokenizer_path对应模型地址即可。
```bash
torchrun --nproc_per_node 1 example_text_completion.py \
    --ckpt_dir Meta-Llama-3-8B/original/ \
    --tokenizer_path Meta-Llama-3-8B/original/tokenizer.model \
    --max_seq_len 128 --max_batch_size 4
```

### Instruction-tuned模型
经过微调的模型被训练用于对话应用程序。为了获得模型的预期特性和性能，需要遵循 [`ChatFormat`](llama/tokenizer.py#L202)中定义的特定格式:
- 提示以特殊令牌 <|begin_of_text|> 开始，之后跟随一个或多个消息。
- 每条消息以标签`<|start_header_id|>`开始，角色为`system`、`user`或者`assistant`、并以标签 `<|end_header_id|>`  结束。
- 在双换行符`\n\n`之后，消息的内容随之而来。
- 每条消息的结尾由`<|eot_id|>`令牌标记。

您还可以部署额外的分类器来过滤被认为不安全的输入和输出。有关如何向推理代码的输入和输出添加安全检查器，请参阅[llama-recipes repo](https://github.com/meta-llama/llama-recipes/blob/main/recipes/inference/local_inference/inference.py) 。

- Meta-Llama-3-8B-Instruct 模型示例，Meta-Llama-3-70B-Instruct模型仅需替换--ckpt_dir、--tokenizer_path对应模型地址即可。
```bash
torchrun --nproc_per_node 1 example_chat_completion.py \
    --ckpt_dir Meta-Llama-3-8B-Instruct/original/ \
    --tokenizer_path Meta-Llama-3-8B-Instruct/original/tokenizer.model \
    --max_seq_len 512 --max_batch_size 6
```

## 多轮对话
1. 确认环境安装及模型下载完毕；
2. 修改[chat.sh](./chat.sh)文件中的 `--ckpt_dir`、`--tokenizer_path` 参数为本地模型地址，`--max_seq_len` 根据自身需求进行修改，调整该值可以增加多轮对话模型的记忆长度，不过需要注意的是这可能会增加模型运算的时间和内存需求；
3. 执行：
```bash
bash chat.sh
```

## Evaluation
1. 安装 `llama-recipes`、`lm-eval` 库
```bash
# llama-recipes 下载
git clone https://github.com/meta-llama/llama-recipes.git
cd ./llama-recipes/recipes/evaluation/
# 修改eval.py第15行代码，将from lm_eval.utils import make_table 改为
from lm_eval.evaluator import make_table
# 修改eval.py第121行代码，num_fewshot参数的默认值改为0
default=0
# 修改eval.py第215行代码，use_cache=args.use_cache 修改为
no_cache=args.use_cache

# 返回根目录
cd ~

# lm-eval 下载
git clone http://developer.hpccube.com/codes/chenych/lm-evaluation-harness.git
cd ./lm-evaluation-harness/
pip install -e .
cd ../
```

2. 修改待测模型**pretrained**参数地址，例如 `/home/Meta-Llama-3-8B-Instruct`，特别地，当前仅支持`hellaswag`数据集进行测试验证。执行以下命令:
```bash
cd /path_of/llama-recipes/recipes/evaluation
python eval.py --model hf --model_args pretrained=/home/llama3/Meta-Llama-3-8B-Instruct,dtype="float" --tasks hellaswag --device cuda --batch_size 8
```
<div align=center>
    <img src="./doc/evaluation.png"/>
</div>

## result
- Meta-Llama-3-8B-Instruct
<div align=center>
    <img src="./doc/Meta-Llama-3-8B-Instruct.png"/>
</div>

- Meta-Llama-3-8B
<div align=center>
    <img src="./doc/Meta-Llama-3-8B.png"/>
</div>

### 精度
暂无


## 应用场景
### 算法类别
对话问答

### 热点应用行业
制造,广媒,家居,教育

## 预训练权重
1. 环境安装
```bash
pip install -U huggingface_hub hf_transfer
export HF_ENDPOINT=https://hf-mirror.com
```

2. 预训练模型下载，**token**参数通过huggingface账号获取

- Meta-Llama-3-8B 模型
```bash
mkdir Meta-Llama-3-8B
huggingface-cli download meta-llama/Meta-Llama-3-8B --include "original/*" --local-dir Meta-Llama-3-8B --token hf_*
```

- Meta-Llama-3-8B-Instruct 模型
```bash
mkdir Meta-Llama-3-8B-Instruct
huggingface-cli download meta-llama/Meta-Llama-3-8B-Instruct --include "original/*" --local-dir Meta-Llama-3-8B-Instruct --token hf_*
```

- Meta-Llama-3-70B 模型
```bash
mkdir Meta-Llama-3-70B
huggingface-cli download meta-llama/Meta-Llama-3-70B --include "original/*" --local-dir Meta-Llama-3-70B --token hf_*
```

- Meta-Llama-3-70B-Instruct 模型
```bash
mkdir Meta-Llama-3-70B-Instruct
huggingface-cli download meta-llama/Meta-Llama-3-70B-Instruct --include "original/*" --local-dir Meta-Llama-3-70B-Instruct --token hf_*
```

模型目录结构如下：
```bash
├── llama3_pytorch
│   ├── Meta-Llama-3-8B
│       └── original
│           ├── consolidated.00.pth
│           ├── params.json
│           └── tokenizer.model
│   ├── Meta-Llama-3-8B-Instruct
│       └── original
│           ├── consolidated.00.pth
│           ├── params.json
│           └── tokenizer.model
│   ├── Meta-Llama-3-70B
│       └── original
│           ├── consolidated.00.pth
│           ├── consolidated.01.pth
│           ├── consolidated.02.pth
│           ├── consolidated.03.pth
│           ├── consolidated.04.pth
│           ├── consolidated.05.pth
│           ├── consolidated.06.pth
│           ├── consolidated.07.pth
│           ├── params.json
│           └── tokenizer.model
│   └── Meta-Llama-3-70B-Instruct
│       └── original
│           ├── consolidated.00.pth
│           ├── consolidated.01.pth
│           ├── consolidated.02.pth
│           ├── consolidated.03.pth
│           ├── consolidated.04.pth
│           ├── consolidated.05.pth
│           ├── consolidated.06.pth
│           ├── consolidated.07.pth
│           ├── params.json
│           └── tokenizer.model
```

## 源码仓库及问题反馈
- https://developer.hpccube.com/codes/modelzoo/llama3_pytorch

## 参考资料
- https://github.com/meta-llama/llama3
- https://github.com/InternLM/xtuner
- https://github.com/SmartFlowAI/EmoLLM
- https://github.com/meta-llama/llama-recipes
