# Latte

## 论文

**Latte: Latent Diffusion Transformer for Video Generation**

* https://arxiv.org/abs/2401.03048v1

## 模型结构

该模型主要使用Transformer结构作为去噪模型。大概流程是这样的，输视频的Embedding，获取相应的Token，然后使用`Transformer Blocks`获取相应的时空信息，接着使用`Layer Norm`和`Linear and Reshape`得到`Noise`和`Variance`。下图的四种变体为不同的时空信息提取方式。

![alt text](readme_imgs/image-1.png)

## 算法原理

该算法的主要思想是将较为常见的`Unet`结构替换为`Transformer`结构作为去噪模型。相较于使用`Unet`，使用`Transformer`可以提升模型的速度，同时`Transformer`可以较好的对时空信息进行建模。

![alt text](readme_imgs/image-2.png)

## 环境配置

### Docker（方法一）

    docker pull image.sourcefind.cn:5000/dcu/admin/base/dtk:23.10-ubuntu20.04-py310

    docker run --shm-size 10g --network=host --name=latte --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v /opt/hyhal:/opt/hyhal -v 项目地址(绝对路径):/home/ -it <your IMAGE ID> bash

    pip install torch-2.1.0a0%2Bgit793d2b5.abi0.dtk2310-cp310-cp310-manylinux2014_x86_64.whl  (whl.zip文件中)

    pip install -r requirements.txt
    pip install torchvision==0.16.1 --no-deps
    pip install timm --no-deps

### Dockerfile（方法二）

    # 需要在对应的目录下
    docker build -t <IMAGE_NAME>:<TAG> .

    docker run --shm-size 10g --network=host --name=latte --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v /opt/hyhal:/opt/hyhal -v 项目地址(绝对路径):/home/ -it <your IMAGE ID> bash

    pip install torch-2.1.0a0%2Bgit793d2b5.abi0.dtk2310-cp310-cp310-manylinux2014_x86_64.whl  (whl.zip文件中)

    pip install -r requirements.txt
    pip install torchvision==0.16.1 --no-deps
    pip install timm --no-deps


### Anaconda (方法三)
1、关于本项目DCU显卡所需的特殊深度学习库可从光合开发者社区下载安装：
https://developer.hpccube.com/tool/

    DTK驱动：dtk23.10
    python：python3.10
    torch:2.1.0 (whl.zip文件中)

Tips：以上dtk驱动、python、torch等DCU相关工具版本需要严格一一对应

2、其它非特殊库参照requirements.txt安装

    pip install -r requirements.txt

    pip install torchvision==0.16.1 --no-deps

    pip install timm --no-deps


## 数据集

|名称|URL|条件|
|:---|:---|:---|
|UCF101|https://www.crcv.ucf.edu/research/data-sets/ucf101/|无|
|FaceForensics|https://github.com/ondyari/FaceForensics/tree/original|填写表格|
|Tachi|https://github.com/AliaksandrSiarohin/first-order-model/blob/master/data/taichi-loading/README.md|无|
|SkyTimelapse|https://drive.google.com/file/d/1xWLiU-MBGN7MrsFHQm4_yXmfHBsMbJQo/view|无|

数据结构，这里为示例数据（仅展示UCF-101），完整数据请按如下结构准备。

    train_datasets/
    └── UCF-101_tiny
        ├── ApplyEyeMakeup
        │   └── v_ApplyEyeMakeup_g01_c01.avi
        ├── ApplyLipstick
        │   └── v_ApplyLipstick_g01_c01.avi
        ├── Archery
        │   └── v_Archery_g01_c01.avi
        ├── BabyCrawling
        │   └── v_BabyCrawling_g01_c01.avi
        ├── BalanceBeam
        │   └── v_BalanceBeam_g01_c01.avi
        ├── BandMarching
        │   └── v_BandMarching_g01_c01.avi


## 训练

    # 训练UCF-101
    torchrun --nnodes=1 --nproc_per_node=N train.py --config ./configs/ucf101/ucf101_train.yaml

注意：训练前需要准备相应的预训练模型，具体参考`推理-模型下载`。

## 推理

### 模型下载

https://hf-mirror.com/maxin-cn/Latte/tree/main

https://hf-mirror.com/PixArt-alpha/PixArt-XL-2-512x512/tree/main/transformer

    share_ckpts/
    ├── ffs.pt
    ├── skytimelapse.pt
    ├── t2v.pt
    └── ...
    
    pretrained_models/
    ├── sd-vae-ft-ema
    │   ├── config.json
    │   └── diffusion_pytorch_model.bin
    ├── sd-vae-ft-mse
    │   ├── config.json
    │   └── diffusion_pytorch_model.bin
    ├── ....
    ├── t2v_required_models
    │   ├── model_index.json
    │   ├── scheduler
    │   │   └── scheduler_config.json
    │   ├── text_encoder
    │   │   ├── config.json
    │   │   ├── model-00001-of-00004.safetensors
    │   │   ├── model-00002-of-00004.safetensors
    │   │   ├── model-00003-of-00004.safetensors
    │   │   ├── model-00004-of-00004.safetensors
    │   │   └── model.safetensors.index.json
    │   ├── tokenizer
    │   │   ├── added_tokens.json
    │   │   ├── special_tokens_map.json
    │   │   ├── spiece.model
    │   │   └── tokenizer_config.json
    │   ├── transformer
    │   │   ├── config.json
    │   │   └── diffusion_pytorch_model.safetensors
    │   └── vae
    │       ├── config.json
    │       └── diffusion_pytorch_model.safetensors
    └── vae
        ├── config.json
        └── diffusion_pytorch_model.bin


### 命令

    # FaceForensics（面部视频）
    # 获取一个视频
    bash sample/ffs.sh

    # 获取多个视频
    bash sample/ffs_ddp.sh

    # sky（天空视频）
    bash sample/sky.sh
    
    bash sample/sky_ddp.sh

    # taichi（打太极视频）
    bash sample/taichi.sh

    bash sample/taichi_ddp.sh

    #ucf101（动作视频）
    bash sample/ucf101.sh

    bash sample/ucf101_ddp.sh

    # 文本->视频
    bash sample/t2v.sh

## result

![alt text](readme_imgs/test.gif)

### 精度

无

## 应用场景

### 算法类别

`视频生成`

### 热点应用行业

`媒体,科研,教育`

## 源码仓库及问题反馈

* https://developer.hpccube.com/codes/modelzoo/latte_pytorch

## 参考资料

* https://github.com/Vchitect/Latte
