# LapSRN

## 论文

` Deep Laplacian Pyramid Networks for Fast and Accurate Super-Resolution `

- https://openaccess.thecvf.com/content_cvpr_2017/papers/Lai_Deep_Laplacian_Pyramid_CVPR_2017_paper.pdf

## 模型结构
 LapSRN模型主要有两个部分，即拉普拉斯金字塔预测模型和残差学习模型。 

![](https://developer.sourcefind.cn/codes/modelzoo/lapsrn_tensorflow/-/raw/master/doc/模型结构.png)

## 算法原理

 该模型是一个图像超分辨率模型，通过逐步放大结构，包括特征提取和图像重建，在每个阶段通过卷积和转置卷积层实现对图像的逐级提升。 

![](https://developer.sourcefind.cn/codes/modelzoo/lapsrn_tensorflow/-/raw/master/doc/%E6%A8%A1%E5%9E%8B%E5%8E%9F%E7%90%86.png)

## 环境配置

### Docker（方法一）

此处提供[光源](https://sourcefind.cn/#/main-page)拉取docker镜像

```
docker pull docker pull image.sourcefind.cn:5000/dcu/admin/base/tensorflow:1.15.1-centos7.6-dtk-22.10.1-py37-latest
docker run -it --network=host --name=bert_prof --privileged --device=/dev/kfd --device=/dev/dri --ipc=host --shm-size=32G  --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root --ulimit stack=-1:-1 --ulimit memlock=-1:-1 image.sourcefind.cn:5000/dcu/admin/base/tensorflow:1.15.1-centos7.6-dtk-22.10.1-py37-latest
pip install -r requirements.txt
```

### Dockerfile（方法二）

dockerfile使用方法

```
docker build --no-cache -t lapsrn:latest .
docker run -dit --network=host --name=lapsrn --privileged --device=/dev/kfd --device=/dev/dri --ipc=host --shm-size=16G  --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root --ulimit stack=-1:-1 --ulimit memlock=-1:-1 lapsrn:latest
docker exec -it lapsrn /bin/bash
```

### Anaconda（方法三）

关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.sourcefind.cn/tool/)开发者社区下载安装。

```
DTK驱动：dtk22.10
python：python3.7
tensorflow==1.15.1+gitf56f27ab.dtk2210
```

`Tips：以上dtk驱动、python等DCU相关工具版本需要严格一一对应`

其它非深度学习库参照requirements.txt安装：

```
pip install -r requirements.txt
```

## 数据集

`模型使用数据为 DIV2K `

-  https://data.vision.ee.ethz.ch/cvl/DIV2K/ 

项目中已提供用于试验训练的迷你数据集，训练数据目录结构如下，用于正常训练的完整数据集请按此目录结构进行制备：

```
 ── datasets
       │   ├── DIV2K_train_HR
       │             ├── xxx.png
       │             ├── xxx.png
       │             └── ...
       │   └── DIV2K_train_LR_bicubic
       │             ├── xxx.png
       │             ├── xxx.png
       │             └── ...
       │   └── DIV2K_valid_HR
       │             ├── xxx.png
       │             ├── xxx.png
       │             └── ...
       │   └── DIV2K_valid_LR_bicubic
       │             ├── xxx.png
       │             ├── xxx.png
       │             └── ...
```




## 训练
### 单机单卡

```
python main.py
```

## 推理

    python main.py -m test \
                   -f TESTIMAGE

## result

测试图

![](https://developer.sourcefind.cn/codes/modelzoo/lapsrn_tensorflow/-/raw/master/datasets/DIV2K_valid_HR/0801.png)

### 精度

测试数据：[DIV2K](https://data.vision.ee.ethz.ch/cvl/DIV2K/) ，使用的加速卡:Z100L。

根据测试结果情况填写表格：

| LAPSRN | loss  |
| :----: | :---: |
| DIV2K  | 0.461 |

## 应用场景

### 算法类别

`图像超分`

### 热点应用行业

`设计`,`制造`,`交通`

## 预训练权重
项目中的预训练权重保存目录为： [LapSRN](./checkpoint/)

## 源码仓库及问题反馈

*  https://developer.sourcefind.cn/codes/modelzoo/lapsrn_tensorflow
## 参考资料
* https://github.com/zjuela/LapSRN-tensorflow 

