# LapSRN
## 模型介绍
LapSRN是一种用于超分辨率重建的神经网络模型。它可以将低分辨率的图像增强到高分辨率，从而提高图像的质量和清晰度。
## 模型结构
LapSRN模型主要有两个部分，即拉普拉斯金字塔预测模型和残差学习模型。
## 数据集
数据集下载地址：DIV2K

https://data.vision.ee.ethz.ch/cvl/DIV2K/

## 训练及推理
### 环境配置

加载环境变量

export PATH={PYTHON3_install_dir}/bin:$PATH

export LD_LIBRARY_PATH={PYTHON3_install_dir}/lib:$LD_LIBRARY_PATH

python依赖安装：

    tensorflow==1.15.1
### 训练
训练命令：

    config.valid.hr_folder_path = '/../LapSRN/data/DIV2K_valid_HR/'
    config.valid.lr_folder_path = '/../LapSRN/data/DIV2K_train_LR_bicubic/X4/'
    
    python main.py


### 测试
测试命令：

    python main.py -m test \
                   -f TESTIMAGE




## 源码仓库及问题反馈
* [https://github.com/zjuela/LapSRN-tensorflow](https://github.com/zjuela/LapSRN-tensorflow)
## 参考
* [https://github.com/zjuela/LapSRN-tensorflow](https://github.com/zjuela/LapSRN-tensorflow)
