# 简介

LapSRN是一种用于超分辨率重建的神经网络模型，全称为Laplacian Pyramid Super-Resolution Network。它可以将低分辨率的图像增强到高分辨率，从而提高图像的质量和清晰度。LapSRN模型基于图像金字塔理论，采用多级金字塔结构，通过渐进性的上采样和细节增强，逐步提高图像分辨率。

LapSRN模型主要有两个部分，即拉普拉斯金字塔预测模型和残差学习模型。拉普拉斯金字塔预测模型通过建立图像金字塔结构，将低分辨率图像逐步上采样到目标分辨率，并通过像素差异来预测高分辨率图像。残差学习模型则用于学习并纠正拉普拉斯金字塔模型中的误差，从而进一步提高图像质量。 

# 测试流程

## 安装工具包

tensorflow1.15版本[[tensorflow-1.15.1_dtk22.04.1-cp37-cp37m-manylinux2014_x86_64](https://cancon.hpccube.com:65024/file/4/tensorflow/dtk22.04.1/tensorflow-1.15.1_dtk22.04.1-cp37-cp37m-manylinux2014_x86_64.whl) ]

## 加载环境变量

```
export PATH={PYTHON3_install_dir}/bin:$PATH

export LD_LIBRARY_PATH={PYTHON3_install_dir}/lib:$LD_LIBRARY_PATH
```

## 下载数据集

数据集下载地址：DIV2K

https://data.vision.ee.ethz.ch/cvl/DIV2K/

## 修改配置文件

```python
config.valid.hr_folder_path = '/../LapSRN/data/DIV2K_valid_HR/'
config.valid.lr_folder_path = '/../LapSRN/data/DIV2K_train_LR_bicubic/X4/'
```



# 运行指令

## 训练模型

```
$ python main.py
```

## 测试

使用您的测试图像运行：

```
$ python main.py -m test -f TESTIMAGE
```

结果可以在文件夹 ./samples/ 中找到

# 参考

[https://github.com/zjuela/LapSRN-tensorflow](https://github.com/zjuela/LapSRN-tensorflow)