# Kimi-VL-A3B-Instruct
## 论文

[Kimi-VL Technical Report](https://arxiv.org/abs/2504.07491)


## 模型结构

它的语言模型部分，采用了我们前一段时间发布的轻量级 MoE 模型 Moonlight，16B总参数，2.8B激活参数。视觉信息处理部分，采用了支持原生分辨率的 MoonViT 编码器——400M 参数 Vison Transformer 架构。该模型采用MoE语言模型、原生分辨率视觉编码器（MoonViT）和MLP投影仪。

<div align=center>
    <img src="./Pic/arch.png"/>
</div>

## 算法原理

ViT是Google团队提出的将Transformer应用在图像分类的模型。ViT将输入图片分为多个patch（16x16），再将每个patch投影为固定长度的向量送入Transformer，后续encoder的操作和原始Transformer中完全相同。但是因为对图片分类，因此在输入序列中加入一个特殊的token，该token对应的输出即为最后的类别预测

<div align=center>
    <img src="./Pic/theory.png"/>
</div>

## 环境配置
### Docker（方法一）
推荐使用docker方式运行， 此处提供[光源](https://www.sourcefind.cn/#/service-details)拉取docker镜像的地址与使用步骤
```
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.3.0-py3.10-dtk24.04.3-ubuntu20.04

docker run -it --shm-size=1024G -v /path/your_code_data/:/path/your_code_data/ -v /opt/hyhal:/opt/hyhal --network=host --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name kimi-vl  <your IMAGE ID> bash # <your IMAGE ID>为以上拉取的docker的镜像ID替换

git clone http://developer.sourcefind.cn/codes/modelzoo/kimi-vl-a3b-instruct_pytorch.git

cd /path/your_code_data/

pip install -r requirements.txt -i https://pypi.tuna.tsinghua.edu.cn/simple

```
Tips:以上dtk驱动、python、torch等DCU相关工具版本需要严格一一对应。

### Dockerfile（方法二）
此处提供dockerfile的使用方法
```
git clone http://developer.sourcefind.cn/codes/modelzoo/kimi-vl-a3b-instruct_pytorch.git

docker build -t internvl:latest .
docker run --shm-size 500g --network=host --name=kimi-vl --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v 项目地址(绝对路径):/home/ -v /opt/hyhal:/opt/hyhal:ro -it <your IMAGE ID> bash


cd /path/your_code_data/

pip install -r requirements.txt -i https://pypi.tuna.tsinghua.edu.cn/simple

```
### Anaconda（方法三）
此处提供本地配置、编译的详细步骤，例如：

关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.sourcefind.cn/tool/)开发者社区下载安装。
```
DTK驱动:dtk24.04.3
python:3.10
torch:2.3.0
transformers>=4.48.0
```
`Tips：以上dtk驱动、python、torch等DCU相关工具版本需要严格一一对应`

其它非深度学习库参照requirement.txt安装：
```

git clone http://developer.sourcefind.cn/codes/modelzoo/kimi-vl-a3b-instruct_pytorch.git

cd /path/your_code_data/

pip install -r requirements.txt -i https://pypi.tuna.tsinghua.edu.cn/simple
```
## 数据集

无

## 训练

无

## 推理

### 单机单卡

```
python Kimi_VL_inference.py
```

### 单机多卡

```
CUDA_VISIBLE_DEVICES=0,1,2,3 python Kimi_VL_inference.py
```

## result


<div align=left>
    <img src="./Pic/result.png"/>
</div>

### 精度

无



## 应用场景

### 算法类别

`对话问答`

### 热点应用行业

`科研,教育,政府,金融`

## 预训练权重


HF/github下载地址为：[moonshotai/Kimi-VL-A3B-Instruct](https://huggingface.co/moonshotai/Kimi-VL-A3B-Instruct)

魔搭下载路径： [moonshotai/Kimi-VL-A3B-Instruct](https://www.modelscope.cn/models/moonshotai/Kimi-VL-A3B-Instruct/files)

## 源码仓库及问题反馈
-  http://developer.sourcefind.cn/codes/modelzoo/kimi-vl-a3b-instruct_pytorch.git

## 参考资料

- https://github.com/MoonshotAI/Kimi-VL

