# Kimi-K2-Instruct-quantized.w4a16
## 论文
[Kimi-K2-Instruct](https://github.com/MoonshotAI/Kimi-K2/blob/main/tech_report.pdf)

## 模型简介
该模型是通过将**Kimi-K2-Instruct**的权重量化为INT4数据类型而获得的。这种优化将表示权重所需的位数从16 (FP16/BF16) 减少到4，从而减少了GPU内存需求（约减少75%）。这种权重量化还使模型的磁盘大小减少了约75%。

原始的Kimi K2是一个最先进的专家混合（MoE）语言模型，具有320亿个激活参数和总共1万亿个参数。使用Muon优化器训练后，Kimi K2在前沿知识、推理和编码任务中表现出色，同时精心优化了代理能力。

**主要特点**
- INT4量化：该模型已被量化为INT4，显著减少了内存占用，并实现了高吞吐量、低延迟的推理。
- 大规模训练：在一个15.5T令牌上预训练了一个1T参数的MoE模型，且无训练不稳定性。
- MuonClip优化器：我们在前所未有的规模上应用了Muon优化器，并开发了新的优化技术来解决扩展过程中的不稳定性问题。
- 代理智能：特别设计用于工具使用、推理和自主解决问题。

<div align=center>
    <img src="./doc/banner.png"/>
</div>

## 环境依赖
| 软件 | 版本 |
| :------: | :------: |
| DTK | 25.04.2 |
| python | 3.10 |
| transformers | 4.57.3 |
| vllm | 0.11 |
| torch | 2.5.1+das.opt1.dtk25041 |

推荐使用镜像: harbor.sourcefind.cn:5443/dcu/admin/base/vllm:0.11.0-ubuntu22.04-dtk25.04.2-1226-das1.7-py3.10-20251226

- 挂载地址`-v`根据实际模型情况修改

```bash
docker run -it \
    --shm-size 60g \
    --network=host \
    --name kimi-k2 \
    --privileged \
    --device=/dev/kfd \
    --device=/dev/dri \
    --device=/dev/mkfd \
    --group-add video \
    --cap-add=SYS_PTRACE \
    --security-opt seccomp=unconfined \
    -u root \
    -v /opt/hyhal/:/opt/hyhal/:ro \
    -v /path/your_code_data/:/path/your_code_data/ \
    harbor.sourcefind.cn:5443/dcu/admin/base/vllm:0.11.0-ubuntu22.04-dtk25.04.2-1226-das1.7-py3.10-20251226 bash
```
更多镜像可前往[光源](https://sourcefind.cn/#/service-list)下载使用。

关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.sourcefind.cn/tool/)开发者社区下载安装。

## 数据集
暂无

## 训练
暂无

## 推理
### vllm
#### 多机推理
1. 环境变量配置
```bash
export HIP_VISIBLE_DEVICES=0,1,2,3,4,5,6,7
export ALLREDUCE_STREAM_WITH_COMPUTE=1
export VLLM_HOST_IP=x.x.x.x # 对应计算节点的IP，建议选择IB口SOCKET_IFNAME对应IP地址
export NCCL_SOCKET_IFNAME=ibxxxx
export GLOO_SOCKET_IFNAME=ibxxxx
export NCCL_IB_HCA=mlx5_0:1 # 根据 ibstat 查看
unset NCCL_ALGO
export NCCL_TOPO_FILE=null
export NCCL_MIN_NCHANNELS=16
export NCCL_MAX_NCHANNELS=16
export NCCL_NET_GDR_READ=1
export VLLM_RPC_TIMEOUT=1800000
# 海光CPU绑定核,intel cpu可不加
export VLLM_NUMA_BIND=1
export VLLM_RANK0_NUMA=0
export VLLM_RANK1_NUMA=1
export VLLM_RANK2_NUMA=2
export VLLM_RANK3_NUMA=3
export VLLM_RANK4_NUMA=4
export VLLM_RANK5_NUMA=5
export VLLM_RANK6_NUMA=6
export VLLM_RANK7_NUMA=7
# 量化相关
export AWQ_MOE_SZ=0
export W4A16_MOE_CUDA=0
export VLLM_USE_LIGHTOP_MOE_ALIGN=0
export VLLM_USE_LIGHTOP=0
export VLLM_USE_PIECEWISE=1
```

2. 启动RAY集群
> x.x.x.x 对应第一步 Master节点的 VLLM_HOST_IP

```bash
# head节点执行
ray start --head --node-ip-address=x.x.x.x --port=6379 --num-gpus=8 --num-cpus=32
# worker节点执行
ray start --address='x.x.x.x:6379' --num-gpus=8 --num-cpus=32
```

3. 启动vllm server
```bash
vllm serve RedHatAI/Kimi-K2-Instruct-quantized.w4a16 \
    --served-model-name kimi-k2 \
    --tensor-parallel-size 16 \
    --dtype float16 \
    --trust-remote-code \
    --port 8001 \
    --distributed-executor-backend ray
```

启动完成后可通过以下方式访问：
> "max_tokens" 参数为必选参数，如不设置，可能出现模型长时间没有输出的问题。
```bash
curl http://localhost:8001/v1/chat/completions   \
    -H "Content-Type: application/json"  \
    -d '{
        "model": "kimi-k2",
        "messages": [
            {"role": "system", "content": "You are Kimi, an AI assistant created by Moonshot AI."},
            {"role": "user", "content": "Please give a brief self-introduction."}
        ],
        "max_tokens": 512,
        "temperature": 0.7
    }'
```

## 效果展示
<div align=center>
    <img src="./doc/result.png"/>
</div>

### 精度
DCU与GPU精度一致，推理框架：vllm。

## 预训练权重
| 模型名称  | 权重大小  | DCU型号  | 最低卡数需求 |下载地址|
|:-----:|:----------:|:----------:|:---------------------:|:----------:|
| Kimi-K2-Instruct-quantized.w4a16 | 146B | BW1000 | 16 | [Hugging Face](https://huggingface.co/RedHatAI/Kimi-K2-Instruct-quantized.w4a16) |

## 源码仓库及问题反馈
- https://developer.sourcefind.cn/codes/modelzoo/kimi-k2-instruct-quantized.w4a16_vllm

## 参考资料
- https://github.com/MoonshotAI/Kimi-K2
- https://huggingface.co/RedHatAI/Kimi-K2-Instruct-quantized.w4a16