# KAT-Dev-vllm
## 论文
暂无

## 模型结构
KAT-Dev-32B基于Qwen3-32B架构构建，采用了现代化的Transformer解码器设计。该架构在保持模型强大推理能力的同时，针对代码生成任务进行了深度优化。其核心设计理念是通过分层注意力机制和扩展的上下文窗口，实现对复杂代码结构的精确建模。

<div align=center>
    <img src="./doc/transformers.jpg"/>
</div>

然而，在KAT-Dev的实现中，注意力机制经过了特殊优化，以更好地处理代码的层次化结构。模型采用了分组查询注意力（GQA）机制，在保证生成质量的同时显著降低了推理时的内存占用。
## 算法原理
KAT-Dev-32B是快手Kwaipilot团队推出的开源代码智能大模型，拥有32亿参数，基于Qwen3-32B架构深度优化，采用Transformer解码器设计。该模型在SWE-Bench Verified基准测试中以62.4%的解决率跻身全球开源模型前五，是唯一突破60%的320亿参数模型。其核心设计通过分层注意力机制和扩展上下文窗口（支持128K长度），实现对复杂代码结构的精确建模。模型训练历经中期训练、监督微调、强化微调及大规模智能体强化学习四阶段，覆盖功能实现、缺陷修复、性能优化等八大任务类型，支持Python、JavaScript、Java等主流编程语言。


## 环境配置
### 硬件需求
DCU型号：BW1000,节点数量：1台,卡数：2张。

`-v 路径`、`docker_name`和`imageID`根据实际情况修改

### Docker（方法一）
```bash
docker pull image.sourcefind.cn:5000/dcu/admin/base/vllm:0.9.2-ubuntu22.04-dtk25.04.1-rc5-rocblas104381-0915-das1.6-py3.10-20250916-rc2
docker run -it --shm-size 200g --network=host --name {docker_name} --privileged --device=/dev/kfd --device=/dev/dri --device=/dev/mkfd --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root -v /path/your_code_data/:/path/your_code_data/ -v /opt/hyhal/:/opt/hyhal/:ro {imageID} bash

cd /your_code_path/kat-dev-vllm
```

### Dockerfile（方法二）
```bash
cd docker
docker build --no-cache -t kat-dev:latest .
docker run -it --shm-size 200g --network=host --name {docker_name} --privileged --device=/dev/kfd --device=/dev/dri --device=/dev/mkfd --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root -v /path/your_code_data/:/path/your_code_data/ -v /opt/hyhal/:/opt/hyhal/:ro {imageID} bash

cd /your_code_path/kat-dev-vllm
```

### Anaconda（方法三）
关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.sourcefind.cn/tool/)开发者社区下载安装。
```bash
DTK: 25.04.1
python: 3.10
vllm: 0.9.2+das.opt1.rc2.dtk25041
torch: 2.5.1+das.opt1.dtk25041
accelerate：1.10.1
transformers: 4.56.1
flash_attn：2.6.1+das.opt16.dtk2504
```
`Tips：以上dtk驱动、python、torch等DCU相关工具版本需要严格一一对应`

## 数据集
无

## 训练
暂无

## 推理
### vllm推理方法
#### server 单机
样例模型：[KAT-Dev](https://huggingface.co/Kwaipilot/KAT-Dev)

```bash
export HIP_VISIBLE_DEVICES=0,1
export ALLREDUCE_STREAM_WITH_COMPUTE=1

vllm serve Kwaipilot/KAT-Dev --trust-remote-code --dtype bfloat16 --max-seq-len-to-capture 32768 -tp 4 --gpu-memory-utilization 0.85 --override-generation-config '{"temperature": 0.7, "top_p":0.8, "top_k":20, "repetition_penalty": 1.05}' --max-model-len 32768
```

启动完成后可通过以下方式访问：
```bash
curl http://x.x.x.x:8000/v1/chat/completions \
    -H "Content-Type: application/json" \
    -d '{
        "model": "Kwaipilot/KAT-Dev",
        "messages": [
            {
                "role": "user",
                "content": "请介绍下自己."
                }
            ]
    }'
```

## result
<div align=center>
    <img src="./doc/result.png"/>
</div>

### 精度
DCU与GPU精度一致，推理框架：vllm。

## 应用场景
### 算法类别
对话问答

### 热点应用行业
制造,广媒,家居,教育

## 预训练权重
- [KAT-Dev](https://huggingface.co/Kwaipilot/KAT-Dev)

## 源码仓库及问题反馈
- https://developer.sourcefind.cn/codes/modelzoo/kat-dev-vllm

## 参考资料
- https://huggingface.co/Kwaipilot/KAT-Dev
