# Janus-Pro-7B

## 论文

`Janus-Series: Unified Multimodal Understanding and Generation Models`

* https://github.com/deepseek-ai/Janus/blob/main/janus_pro_tech_report.pdf


## 模型结构

是一个新颖的自回归框架，统一了多模态理解和生成。它通过将视觉编码解耦到单独的路径中，同时仍然利用单个统一的transformer架构进行处理，解决了以前方法的局限性。这种解耦不仅缓解了视觉编码器在理解和生成中的角色之间的冲突，而且增强了框架的灵活性。骏利超越了以前的统一模型，匹配或超过了特定任务模型的性能。Janus的简单性、高灵活性和有效性使其成为下一代统一多模式模型的有力候选。

![alt text](images/arch.png)

## 算法原理

Janus-Pro是之前工作Janus的高级版本。具体来说，Janus-Pro结合了（1）优化的训练策略（2）扩展的训练数据和（3）扩展到更大的模型尺寸。通过这些改进，Janus-Pro在多模态理解和文本到图像指令跟踪功能方面取得了重大进步，同时还增强了文本到图像生成的稳定性。
![alt text](images/theory.png)

## 环境配置

### Docker（方法一）
    
    docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.3.0-ubuntu22.04-dtk24.04.3-py3.10

    docker run --shm-size 500g --network=host --name=Janus --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v 项目地址(绝对路径):/home/ -v /opt/hyhal:/opt/hyhal:ro -it <your IMAGE ID> bash

    cd ./code_path/
    pip install -r requirements.txt


### Dockerfile（方法二）

    docker build -t <IMAGE_NAME>:<TAG> .

    docker run --shm-size 500g --network=host --name=Janus --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v 项目地址(绝对路径):/home/ -v /opt/hyhal:/opt/hyhal:ro -it <your IMAGE ID> bash

    cd ./code_path/
    pip install -r requirements.txt

### Anaconda（方法三）

关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.hpccube.com/tool/)开发者社区下载安装。
```
DTK驱动：dtk24.04.3
python：python3.10
torch:2.3.0
torchvision: 0.18.0
```
`Tips：以上dtk驱动、python、paddle等DCU相关工具版本需要严格一一对应`

关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.hpccube.com/tool/)开发者社区下载安装。
```
conda create -n janus-pro python=3.10
conda activate janus-pro

cd ./project_path

pip install -r requirements.txt -i http://mirrors.aliyun.com/pypi/simple
```



## 数据集

无

## 训练

无

## 推理

注意：修改模型路径及图片路径


**图片问答**

```
python inference.py
```
**文生图**

```
python generation_inference.py
```

## result

**图片问答**

![alt text](images/result1.png)

**文生图**

![alt text](images/result2.png)

### 精度

无

## 应用场景

### 算法类别

`以文生图`

### 热点应用行业

`电商,教育,广媒,政府`

## 预训练权重
huggingface:
[Janus-Pro-7B](https://hf-mirror.com/deepseek-ai/Janus-Pro-7B) 

SCNet高速下载通道:
[Janus-Pro-7B](https://www.scnet.cn/ui/aihub/models/openaimodels/Janus-Pro-7B)

## 源码仓库及问题反馈

* https://developer.sourcefind.cn/codes/modelzoo/janus-pro-7b_pytorch

## 参考资料

* https://github.com/deepseek-ai/Janus
