# InterVL2.5
## 论文

[Expanding Performance Boundaries of Open-Source Multimodal Models with Model, Data, and Test-Time Scaling](https://arxiv.org/abs/2412.05271)


## 模型结构
InternVL 2.5保留了与InternVL 1.5[35]相同的模型架构，并且
InternVL 2.0，即广泛使用的“ViT-MLP-LLM”范式，结合了预先训练的InternViT-300M
或通过MLP投影仪具有各种尺寸的LLM[19，229]的InternViT-6B。与之前的版本一致，
我们应用像素反洗牌操作来减少每个448 × 448图像块产生的1024个视觉令牌
到256个代币。此外，与InternVL 1.5相比，InternVL 2.0和2.5引入了额外的数据类型，
将多图像和视频数据与现有的单图像和纯文本数据合并。



<div align=center>
    <img src="./Pic/arch.png"/>
</div>

## 算法原理

InternVL 2.5训练过程分为三个阶段——阶段1（MLP预热）可选阶段1.5（ViT增量学习）和阶段2（全模型指令调优）。多阶段设计逐步增强视觉-语言对齐，稳定培训，并为与更大的LLM集成准备模块。(b)逐步扩大战略。在早期阶段用较小的LLM训练的ViT模块可以很容易地与较大的LLM集成，以可承受的资源开销实现可扩展的模型对齐。

<div align=center>
    <img src="./Pic/theory.png"/>
</div>

## 环境配置
### Docker（方法一）
推荐使用docker方式运行， 此处提供[光源](https://www.sourcefind.cn/#/service-details)拉取docker镜像的地址与使用步骤
```
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.3.0-py3.10-dtk24.04.3-ubuntu20.04
docker run -it --shm-size=1024G -v /path/your_code_data/:/path/your_code_data/ -v /opt/hyhal:/opt/hyhal --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name internvl  <your IMAGE ID> bash # <your IMAGE ID>为以上拉取的docker的镜像ID替换

git clone http://developer.sourcefind.cn/codes/modelzoo/internvl2.5_pytorch.git

cd /path/your_code_data/

pip install -r requirements.txt -i https://pypi.tuna.tsinghua.edu.cn/simple

```
Tips:以上dtk驱动、python、torch等DCU相关工具版本需要严格一一对应。
### Dockerfile（方法二）
此处提供dockerfile的使用方法
```
docker build -t internvl:latest .
docker run --shm-size 500g --network=host --name=internvl --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v 项目地址(绝对路径):/home/ -v /opt/hyhal:/opt/hyhal:ro -it <your IMAGE ID> bash


git clone http://developer.sourcefind.cn/codes/modelzoo/internvl2.5_pytorch.git

cd /path/your_code_data/

pip install -r requirements.txt -i https://pypi.tuna.tsinghua.edu.cn/simple

```
### Anaconda（方法三）
此处提供本地配置、编译的详细步骤，例如：

关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.hpccube.com/tool/)开发者社区下载安装。
```
DTK驱动:dtk24.04.3
python:3.10
torch:2.3.0
flash-attn:2.6.1
```
`Tips：以上dtk驱动、python、torch等DCU相关工具版本需要严格一一对应`

其它非深度学习库参照requirement.txt安装：
```
git clone http://developer.sourcefind.cn/codes/modelzoo/internvl2.5_pytorch.git

cd /path/your_code_data/

pip install -r requirements.txt -i https://pypi.tuna.tsinghua.edu.cn/simple

```
## 数据集

无

## 训练


无

### 单机多卡

无

## 推理

### 单机多卡


```
python internvl_inference.py
```


## result

- 多模态推理

<div align=left>
    <img src="./Pic/result.png"/>
</div>



### 精度

无



## 应用场景

### 算法类别

`对话问答`

### 热点应用行业

`科研,教育,政府,金融`

## 预训练权重

模型可在[SCNet](http://113.200.138.88:18080/aimodels/)进行搜索下载

- [OpenGVLab/InternVL2_5模型下载SCNet链接](http://113.200.138.88:18080/aimodels/OpenGVLab/InternVL2_5)

## 源码仓库及问题反馈
- https://developer.sourcefind.cn/codes/modelzoo/internvl2.5_pytorch

## 参考资料

- https://modelscope.cn/models/OpenGVLab/InternVL2_5-8B
- https://github.com/OpenGVLab/InternVL


