# InternVL2.5
## 论文
[Expanding Performance Boundaries of Open-Source Multimodal Models with Model, Data, and Test-Time Scaling](https://arxiv.org/abs/2412.05271)

## 模型简介
InternVL 2.5 保留了与前代模型 InternVL 1.5 和 2.0 相同的模型架构，遵循“ViT-MLP-LLM”范式。在新版本中，使用随机初始化的 MLP 投影器集成了一个新增量预训练的 InternViT 与各种预训练 LLM（包括 InternLM 2.5 和 Qwen 2.5）。
正如之前的版本一样，应用了像素解混操作，将视觉标记的数量减少到原来的四分之一。此外，采用了与InternVL 1.5类似的动态分辨率策略，将图像分割成448×448像素的块。从InternVL 2.0开始的关键区别在于，额外引入了对多图像和视频数据的支持。

<div align=center>
    <img src="./Pic/arch.png"/>
</div>

## 环境依赖
- 列举基础环境需求，根据实际情况填写

| 软件 | 版本 |
| :------: | :------: |
| DTK | 24.04.3 |
| python | 3.10 |
| torch | 2.3.0 |
| transformers | >=4.37.2 |
| flash-attn | 2.6.1 |

推荐使用镜像:

- 挂载地址`-v`，`{docker_name}`和 `{docker_image_name}`根据实际模型情况修改

```bash
docker run -it --shm-size 200g --network=host --name {docker_name} --privileged --device=/dev/kfd --device=/dev/dri --device=/dev/mkfd --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root -v /path/your_code_path/:/path/your_code_path/ -v /opt/hyhal/:/opt/hyhal/:ro {docker_image_name} bash

示例如下：
docker run -it --shm-size=1024G --network=host --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name internvl -v /path/your_code_data/:/path/your_code_data/ -v /opt/hyhal:/opt/hyhal  image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.3.0-py3.10-dtk24.04.3-ubuntu20.04 bash
docker run -it --shm-size 200g --network=host --name qwen3 --privileged --device=/dev/kfd --device=/dev/dri --device=/dev/mkfd --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root -v /path/your_code_path/:/path/your_code_path/ -v /opt/hyhal/:/opt/hyhal/:ro image.sourcefind.cn:5000/dcu/admin/base/vllm:0.9.2-ubuntu22.04-dtk25.04.2-py3.10 bash
```
更多镜像可前往[光源](https://sourcefind.cn/#/service-list)下载使用。

关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.sourcefind.cn/tool/)开发者社区下载安装，其它包参照requirements.txt安装：
```bash
pip install -r requirements.txt
pip install accelerate
```

## 数据集
暂无

## 训练
暂无

## 推理
### transformers
#### 单机推理
此处以[OpenGVLab/InternVL2_5-26B](https://www.modelscope.cn/models/OpenGVLab/InternVL2_5-26B)为例
```bash
export HIP_VISIBLE_DEVICES=0,1
python internvl_inference.py
```

## 效果展示
- 多模态推理
<div align=left>
    <img src="./Pic/result.png"/>
</div>

### 精度
DCU与GPU精度一致，推理框架：transformers。

## 预训练权重
| 模型名称  | 权重大小  | DCU型号  | 最低卡数需求 |下载地址|
|:-----:|:----------:|:----------:|:---------------------:|:----------:|
| InternVL 2.5 | 1B | K100AI| 1 | [Modelscope](https://www.modelscope.cn/models/OpenGVLab/InternVL2_5-1B) |
| InternVL 2.5 | 2B | K100AI| 1 | [Modelscope](https://www.modelscope.cn/models/OpenGVLab/InternVL2_5-2B) |
| InternVL 2.5 | 4B | K100AI| 1 | [Modelscope](https://www.modelscope.cn/models/OpenGVLab/InternVL2_5-4B) |
| InternVL 2.5 | 8B | K100AI| 1 | [Modelscope](https://www.modelscope.cn/models/OpenGVLab/InternVL2_5-8B) |
| InternVL 2.5 | 26B | K100AI| 2 | [Modelscope](https://www.modelscope.cn/models/OpenGVLab/InternVL2_5-26B) |
| InternVL 2.5 | 38B | K100AI| 2 | [Modelscope](https://www.modelscope.cn/models/OpenGVLab/InternVL2_5-38B) |
| InternVL 2.5 | 78B | K100AI| 4 | [Modelscope](https://www.modelscope.cn/models/OpenGVLab/InternVL2_5-78B) |

## 源码仓库及问题反馈
- https://developer.sourcefind.cn/codes/modelzoo/internvl2.5_pytorch

## 参考资料
- https://github.com/OpenGVLab/InternVL
