# InternLM
## 论文
无

## 模型结构
InternLM 是一个开源的轻量级训练框架，旨在支持模型预训练，而不需要大量的依赖。InternLM深度整合了Flash-attention,Apex等高性能模型算子，提高了训练效率。通过架构Hybrid Zero技术，实现计算和通信的高效重叠，大幅降低了训练过程中的跨节点通信流量。

![img](./docs/interlm.jpg)

## 算法原理
InterLM是一个基础语言模型的集合,参数范围从7B到20B。在数万亿的tokens上训练出的模型，并表明可以专门使用公开可用的数据集来训练最先进的模型，而不依赖于专有的和不可访问的数据集。

![img](./docs/interlm.png)

## 环境配置

* 提供光源拉取推理的docker镜像：

  ```bash
  docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.1.0-ubuntu20.04-dtk24.04.1-py3.10(推荐)
  docker pull image.sourcefind.cn:5000/dcu/admin/base/custom:lmdeploy0.0.13_dtk23.04_torch1.13_py38
  # <Image ID>用上面拉取docker镜像的ID替换
  # <Host Path>主机端路径
  # <Container Path>容器映射路径
  docker run -it --name baichuan --shm-size=1024G  --device=/dev/kfd --device=/dev/dri/ --cap-add=SYS_PTRACE --security-opt seccomp=unconfined --ulimit memlock=-1:-1 --ipc=host --network host --group-add video -v <Host Path>:<Container Path> <Image ID> /bin/bash
  ```

  镜像版本依赖：

  * DTK驱动：24.04.1
  * Pytorch: 2.1.0
  * python: python3.10

  > [!NOTE]
  >
  > 使用lmdeploy0.0.13_dtk23.04_torch1.13_py38如果遇到 importError:libgemm multiB int4.so: cannot open shared obiect file: No such file or directory
  >
  > 解决方法：
  >
  > ```bash
  > rm /usr/local/lib/python3.8/site-packages/_turbomind.cpython-38-x86_64-linux-gnu.so
  > ```


## 数据集
无

## 推理

### 源码编译安装
```bash
# 若使用光源的镜像，可以跳过源码编译安装，镜像里面安装好了lmdeploy。
git clone http://developer.hpccube.com/codes/modelzoo/llama_lmdeploy.git
cd llama_lmdeploy
git submodule init && git submodule update
cd lmdeploy
mkdir build && cd build
sh ../generate.sh
make -j 32
make install
cd .. && python3 setup.py install
```

### 运行前

```bash
#step 1
cd lmdeploy
pip install -r requirements.txt -i https://pypi.tuna.tsinghua.edu.cn/simple
#step 2
source /opt/dtk/cuda/env.sh
```

### 运行 internlm-chat-7

```bash
# 模型转换
# <model_name> 模型的名字 （'llama', 'internlm', 'vicuna', 'internlm-chat-7b', 'internlm-chat', 'internlm-chat-7b-8k', 'internlm-chat-20b', 'internlm-20b', 'baichuan-7b', 'baichuan2-7b', 'llama2', 'qwen-7b', 'qwen-14b'）
# <model_path> 模型路径
# <model_format> 模型的格式 （'llama', 'hf', 'qwen'）
# <tokenizer_path> tokenizer模型的路径（默认None,会去model_path里面找tokenizer.model）
# <model_format> 保存输出的目标路径（默认./workspace）
# <tp> 用于张量并行的GPU数量应该是2^n

# bash界面运行
lmdeploy chat turbomind  ./workspace_interlm7b --tp 1     # 输入问题后执行2次回车进行推理

# 服务器网页端运行

在bash端运行：
# <model_path_or_server> 部署模型的路径或tritonserver URL或restful api URL。前者用于与gradio直接运行服务。后者用于默认情况下使用tritonserver运行。如果输入URL是restful api。请启用另一个标志“restful_api”。
# <server_name> gradio服务器的ip地址
# <server_port> gradio服务器的ip的端口
# <batch_size> 于直接运行Turbomind的batch大小 （默认32）
# <tp> 用于张量并行的GPU数量应该是2^n （和模型转换的时候保持一致）
# <restful_api> modelpath_or_server的标志（默认是False）

lmdeploy serve gradio  ./workspace_interlm7b --server-name {ip} --server-port {port} --batch_size 32 --tp 1 --restful_api False 

在网页上输入{ip}:{port}即可进行对话
```

### 运行 internlm-chat-20b
```bash
# bash界面运行
lmdeploy chat turbomind  ./workspace_interlm20b --tp 4

# 服务器网页端运行

在bash端运行：
lmdeploy serve gradio ./workspace_interlm20b --server-name {ip} --server-port {port} --batch_size 32 --tp 4 --restful_api False 

在网页上输入{ip}:{port}即可进行对话
```


## result
![interlm](docs/interlm.gif)

### 精度

无

## 应用场景

### 算法类别

`对话问答`


### 热点应用行业

`金融,科研,教育`


## 预训练权重

[internlm-chat-7b](https://huggingface.co/internlm/internlm-chat-7b)

[internlm-chat-20b](https://huggingface.co/internlm/internlm-chat-20b)


预训练权重快速下载中心：[SCNet AIModels](http://113.200.138.88:18080/aimodels)

项目中的预训练权重可从快速下载通道下载： [internlm-chat-7b](http://113.200.138.88:18080/aimodels/internlm-chat-7b)
                                     [internlm-chat-20b](http://113.200.138.88:18080/aimodels/internlm-chat-20b)

## 源码仓库及问题反馈
https://developer.hpccube.com/codes/modelzoo/internlm_lmdeploy

## 参考资料
https://github.com/InternLM/LMDeploy
