# InternLM
## 论文
无

## 模型结构
InternLM 是一个开源的轻量级训练框架，旨在支持模型预训练，而不需要大量的依赖。InternLM深度整合了Flash-attention,Apex等高性能模型算子，提高了训练效率。通过架构Hybrid Zero技术，实现计算和通信的高效重叠，大幅降低了训练过程中的跨节点通信流量。

![img](./docs/interlm.jpg)

## 算法原理
InterLM是一个基础语言模型的集合,参数范围从7B到20B。在数万亿的tokens上训练出的模型，并表明可以专门使用公开可用的数据集来训练最先进的模型，而不依赖于专有的和不可访问的数据集。

![img](./docs/interlm.png)

## 环境配置

* 提供光源拉取推理的docker镜像：

  ```bash
  docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.1.0-ubuntu20.04-dtk24.04.1-py3.10(推荐)
  # <Image ID>用上面拉取docker镜像的ID替换
  # <Host Path>主机端路径
  # <Container Path>容器映射路径
  docker run -it --name baichuan --shm-size=1024G  --device=/dev/kfd --device=/dev/dri/ --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v /opt/hyhal:/opt/hyhal:ro --ulimit memlock=-1:-1 --ipc=host --network host --group-add video -v <Host Path>:<Container Path> <Image ID> /bin/bash
  ```

  镜像版本依赖：

  * DTK驱动：24.04.1
  * Pytorch: 2.1.0
  * python: python3.10


## 数据集
无

## 推理

### 源码编译安装
```bash
# 若使用光源的镜像，可以跳过源码编译安装，镜像里面安装好了lmdeploy。
git clone http://developer.hpccube.com/codes/modelzoo/llama_lmdeploy.git
cd llama_lmdeploy
git submodule init && git submodule update
cd lmdeploy
mkdir build && cd build
sh ../generate.sh
make -j 32
make install
cd .. && python3 setup.py install
```

### 运行前

```bash
#step 1
cd lmdeploy
pip install -r requirements.txt -i https://pypi.tuna.tsinghua.edu.cn/simple
#step 2
source /opt/dtk/cuda/env.sh
```

### 运行 internlm-chat-7b

```bash
# 模型转换
# <tp> 用于张量并行的GPU数量应该是2^n

# bash界面运行
lmdeploy chat turbomind  ./path_to_interlm7b --tp 1     # 输入问题后执行2次回车进行推理

# 服务器网页端运行

在bash端运行：
# <server-name> gradio服务器的ip地址
# <server-port> gradio服务器的ip的端口
# <tp> 用于张量并行的GPU数量应该是2^n （和模型转换的时候保持一致）

lmdeploy serve gradio  ./path_to_interlm7b --server-name {ip} --server-port {port}

在网页上输入{ip}:{port}即可进行对话
```

### 运行 internlm-chat-20b
```bash
# bash界面运行
lmdeploy chat turbomind  ./path_to_interlm20b --tp 4

# 服务器网页端运行

在bash端运行：
lmdeploy serve gradio ./path_to_interlm20b --server-name {ip} --server-port {port} --tp 4

在网页上输入{ip}:{port}即可进行对话
```


## result
![interlm](docs/interlm.gif)

### 精度

无

## 应用场景

### 算法类别

`对话问答`


### 热点应用行业

`金融,科研,教育`


## 预训练权重

[internlm-chat-7b](https://huggingface.co/internlm/internlm-chat-7b)

[internlm-chat-20b](https://huggingface.co/internlm/internlm-chat-20b)


预训练权重快速下载中心：[SCNet AIModels](http://113.200.138.88:18080/aimodels)

项目中的预训练权重可从快速下载通道下载： [internlm-chat-7b](http://113.200.138.88:18080/aimodels/internlm-chat-7b)
                                     [internlm-chat-20b](http://113.200.138.88:18080/aimodels/internlm-chat-20b)

## 源码仓库及问题反馈
https://developer.hpccube.com/codes/modelzoo/internlm_lmdeploy

## 参考资料
https://github.com/InternLM/LMDeploy
