# InstantID

## 论文

**InstantID:Zero-shot Identity-Preserving Generation in Seconds**

* https://arxiv.org/pdf/2401.07519.pdf

## 模型结构

该模型主要结构为Stable Diffusion，并使用`IdentityNet`（提取面部特征），`IPA`（`Porjection + FaceEmbedding + Cross Attention`，获取面部prompt）以及`Text Encoder + Text Embedding + Cross Attention`（获取文字prompt）的输出作为`Unet`的控制条件。

![Alt text](readme_imgs/image-1.png)

## 算法原理

该算法在`ControlNet`思想的基础上，通过增加`IdentityNet`，`IPA`等获取面部特征及Prompt，并将此作为`Unet`的控制条件，具体如下

1、IdentityNet

仅使用五个面部关键点（两个用于眼睛，一个用于鼻子，两个用于嘴巴）作为条件输入；取消了文本提示，并将ID嵌入作为ControlNet中交叉注意力层的条件。

![Alt text](readme_imgs/image-2.png)

2、IPA

引入了一种轻量级的自适应模块，其中包含独立的交叉注意力，以支持图像作为提示。

## 环境配置

### Docker（方法一）

    docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:1.13.1-centos7.6-dtk-23.04.1-py39-latest
    docker run --shm-size 10g --network=host --name=instantid --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v 项目地址(绝对路径):/home/ -it <your IMAGE ID> bash

    pip install -r requirements.txt

### Dockerfile（方法二）

    # 需要在对应的目录下
    docker build -t <IMAGE_NAME>:<TAG> .
    # <your IMAGE ID>用以上拉取的docker的镜像ID替换
    docker run --shm-size 10g --network=host --name=instantid --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v 项目地址(绝对路径):/home/ -it <your IMAGE ID> bash

    pip install -r requirements.txt


## 数据集

无

## 推理

### 模型下载

|url|名称|是否必要|
|:---|:-----|:----|
|https://huggingface.co/InstantX/InstantID||是|
|https://huggingface.co/wangqixun/YamerMIX_v8/tree/main||是|
|https://drive.google.com/file/d/18wEUfMNohBJ4K3Ly5wpTejPfDzp-8fI8/view|antelopev2|是|
|https://huggingface.co/latent-consistency/lcm-lora-sdxl/tree/main|pytorch_lora_weights|是|
|https://huggingface.co/FMNing/sd-control-facenet/tree/main|facenet|否|
|https://hf-mirror.com/diffusers/controlnet-canny-sdxl-1.0/tree/main||否|
|https://hf-mirror.com/diffusers/controlnet-depth-sdxl-1.0-small/tree/main||否|
|https://hf-mirror.com/Intel/dpt-hybrid-midas/tree/main||否|
|https://huggingface.co/lllyasviel/ControlNet/tree/main/annotator/ckpts||否|
|https://huggingface.co/thibaud/controlnet-openpose-sdxl-1.0/tree/main||否|


注意：如果huggingface无法访问，可访问（ https://hf-mirror.com/ ），
`是否必须`中`否`涉及的模型仅在`app-multicontrolnet.py`需要。


    models/
    └── antelopev2
        ├── 1k3d68.onnx
        ├── 2d106det.onnx
        ├── genderage.onnx
        ├── glintr100.onnx
        └── scrfd_10g_bnkps.onnx
    
    checkpoints/
    ├── ControlNetModel
    │   ├── config.json
    │   └── diffusion_pytorch_model.safetensors
    ├── diffusers
    │   ├── controlnet-canny-sdxl-1.0
    │   │   ├── config.json
    │   │   └── diffusion_pytorch_model.bin
    │   └── controlnet-depth-sdxl-1.0-small
    │       ├── config.json
    │       └── diffusion_pytorch_model.bin
    ├── Intel
    │   └── dpt-hybrid-midas
    │       ├── config.json
    │       ├── preprocessor_config.json
    │       └── pytorch_model.bin
    ├── ip-adapter.bin
    ├── lllyasviel
    │   └── ControlNet
    │       └── annotator
    │           └── ckpts
    │               ├── body_pose_model.pth
    │               ├── facenet.pth
    │               └── hand_pose_model.pth
    ├── pytorch_lora_weights.safetensors
    ├── thibaud
    │   └── controlnet-openpose-sdxl-1.0
    │       ├── config.json
    │       └── diffusion_pytorch_model.bin
    └── wangqixun
        └── YamerMIX_v8
            ├── model_index.json
            ├── scheduler
            │   └── scheduler_config.json
            ├── text_encoder
            │   ├── config.json
            │   └── model.safetensors
            ├── text_encoder_2
            │   ├── config.json
            │   └── model.safetensors
            ├── tokenizer
            │   ├── merges.txt
            │   ├── special_tokens_map.json
            │   ├── tokenizer_config.json
            │   └── vocab.json
            ├── tokenizer_2
            │   ├── merges.txt
            │   ├── special_tokens_map.json
            │   ├── tokenizer_config.json
            │   └── vocab.json
            ├── unet
            │   ├── config.json
            │   └── diffusion_pytorch_model.safetensors
            └── vae
                ├── config.json
                └── diffusion_pytorch_model.safetensors


### 命令

    python gradio_demo/app.py

    # 多controlnet
    python gradio_demo/app-multicontrolnet.py 

## result

#### app.py

左边为输入图像，右边为输出图像

![Alt text](readme_imgs/image-3.png)

#### app-multicontrolnet

左边为输入图像，右边为输出图像

![Alt text](readme_imgs/image-4.png)

### 精度

无

## 应用场景

### 算法类别

`AIGC`

### 热点行业

`零售,广媒,设计`

## 源码仓库及问题反馈

* https://developer.hpccube.com/codes/modelzoo/instantid_pytorch

## 参考资料

* https://github.com/InstantID/InstantID
