# IndexTTS-vLLM

## 论文

IndexTTS2: A Breakthrough in Emotionally Expressive and Duration-Controlled Auto-Regressive Zero-Shot Text-to-Speech

https://arxiv.org/abs/2506.21619

## 模型结构

IndexTTS2 是 B 站提出的零样本可控 TTS 模型，采用 “自回归 + 非自回归” 级联架构，核心由 Text‑to‑Semantic（T2S）、Semantic‑to‑Mel（S2M）、BigVGANv2 声码器 三大模块组成，支持精确时长控制与情感‑音色解耦，适配零样本语音合成与视频配音等场景。
模型采用三阶段流水线，输入文本、音色 / 风格提示、可选时长控制，输出高保真语音，流程如下：
1.文本→语义 Token（T2S）：自回归生成带时长 / 情感约束的语义 Token；
2.语义 Token→梅尔频谱（S2M）：非自回归流匹配生成梅尔谱，融入 GPT 隐表示保障情感清晰度；
3.梅尔频谱→波形（声码器）：BigVGANv2 转波形，兼顾音质与推理速度。

![images](https://developer.sourcefind.cn/codes/modelzoo/index-tts-vllm/-/raw/master/assets/IndexTTS2.png?inline=false)

## 环境配置

### Docker（方法一）

```
在光源可拉取docker镜像：
docker pull image.sourcefind.cn:5000/dcu/admin/base/vllm:0.9.2-ubuntu22.04-dtk25.04.1-rc5-rocblas104381-0915-das1.6-py3.10-20250916-rc2-ds3.2
创建并启动容器：
docker run -it --network=host --name=dtk25041_torch25 -v /opt/hyhal:/opt/hyhal:ro -v /usr/local/hyhal:/usr/local/hyhal:ro -v /public:/public:ro --privileged --device=/dev/kfd --device=/dev/dri --ipc=host --shm-size=128G  --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root --ulimit stack=-1:-1 --ulimit memlock=-1:-1 image.sourcefind.cn:5000/dcu/admin/base/vllm:0.9.2-ubuntu22.04-dtk25.04.1-rc5-rocblas104381-0915-das1.6-py3.10-20250916-rc2-ds3.2
docker exec -it dtk25041_torch25 /bin/bash
安装依赖包：
cd index-tts-vllm/
pip install http://112.11.119.99:18000/customized/vllm/dtk25.04.1/vllm-0.10.2%2Bdas.opt1.alpha.dfe1a84.dtk25041-cp310-cp310-linux_x86_64.whl   # 安装vllm0.10.2
pip install -r requirements.txt -i http://mirrors.aliyun.com/pypi/simple/ --trusted-host mirrors.aliyun.com
pip install http://112.11.119.99:18000/customized/torchaudio/dtk25.04.2/torchaudio251-hip/torchaudio-2.5.1%2Bdas.opt1.dtk25042-cp310-cp310-manylinux_2_28_x86_64.whl --force-reinstall --no-deps    # 安装指定版本的torchaudio
# 安装Qt5
apt update && apt install -y libqt5core5a libgstreamer-plugins-good1.0-0 gstreamer1.0-plugins-base
# vllm必须安装指定的0.10.2版本，torchaudio需要卸载安装指定whl包
```
### Dockerfile（方法二）

```
docker build --no-cache -t index-tts-vllm:latest .
docker run -dit --network=host --name=index-tts-vllm --privileged --device=/dev/kfd --device=/dev/dri --ipc=host --shm-size=16G  --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root --ulimit stack=-1:-1 --ulimit memlock=-1:-1 -v /opt/hyhal/:/opt/hyhal/:ro -v /usr/local/hyhal:/usr/local/hyhal:ro index-tts-vllm:latest
docker exec -it index-tts-vllm /bin/bash
安装依赖包：
cd index-tts-vllm/
pip install http://112.11.119.99:18000/customized/vllm/dtk25.04.1/vllm-0.10.2%2Bdas.opt1.alpha.dfe1a84.dtk25041-cp310-cp310-linux_x86_64.whl   # 安装vllm0.10.2
pip install -r requirements.txt -i http://mirrors.aliyun.com/pypi/simple/ --trusted-host mirrors.aliyun.com
pip install http://112.11.119.99:18000/customized/torchaudio/dtk25.04.2/torchaudio251-hip/torchaudio-2.5.1%2Bdas.opt1.dtk25042-cp310-cp310-manylinux_2_28_x86_64.whl --force-reinstall --no-deps    # 安装指定版本的torchaudio
# 安装Qt5
apt update && apt install -y libqt5core5a libgstreamer-plugins-good1.0-0 gstreamer1.0-plugins-base
# vllm必须安装指定的0.10.2版本，torchaudio需要卸载安装指定whl包
```

### Anaconda（方法三）

```
1.创建conda虚拟环境：
conda create -n index-tts-vllm python=3.10
2.关于本项目DCU显卡所需的工具包、深度学习库等均可从光合开发者社区下载安装：https://developer.hpccube.com/tool/
DTK驱动：dtk25.04.1
python：python3.10
torch:2.5.1
Tips：以上DTK、python、torch等DCU相关工具包，版本需要严格一一对应
3.其它非特殊库参照requirements.txt安装
pip install -r requirements.txt -i http://mirrors.aliyun.com/pypi/simple/ --trusted-host mirrors.aliyun.com
pip install http://112.11.119.99:18000/customized/vllm/dtk25.04.1/vllm-0.10.2%2Bdas.opt1.alpha.dfe1a84.dtk25041-cp310-cp310-linux_x86_64.whl   # 安装vllm0.10.2
pip install http://112.11.119.99:18000/customized/torchaudio/dtk25.04.2/torchaudio251-hip/torchaudio-2.5.1%2Bdas.opt1.dtk25042-cp310-cp310-manylinux_2_28_x86_64.whl --force-reinstall --no-deps    # 安装指定版本的torchaudio
# 安装Qt5
apt update && apt install -y libqt5core5a libgstreamer-plugins-good1.0-0 gstreamer1.0-plugins-base
# vllm必须安装指定的0.10.2版本，torchaudio需要卸载安装指定whl包
```

## 测试数据集

无

## 预训练模型

模型权重下载到 `checkpoints/` 路径下：

```
modelscope download --model kusuriuri/IndexTTS-2-vLLM --local_dir ./checkpoints/IndexTTS-2-vLLM
```

## 推理

#### 单机单卡推理

使用 fastapi 封装了 api 接口，启动示例如下：

```
python api_server_v2.py
```

#### 启动参数

- `--model_dir`: 必填，模型权重路径
- `--host`: 服务ip地址，默认为 `0.0.0.0`
- `--port`: 服务端口，默认为 `6006`
- `--gpu_memory_utilization`: vllm 显存占用率，默认设置为 `0.25`

#### API 请求示例

```
python api_example_v2.py
```

## result

无

## 精度

无

### 应用场景

### 算法类别

文本转语音（TTS）领域

### 热点应用行业

医疗,教育,科研,游戏娱乐

## 源码仓库及问题反馈

- https://developer.sourcefind.cn/codes/modelzoo/index-tts-vllm

## 参考资料
- https://github.com/Ksuriuri/index-tts-vllm

  
