# InceptionV3
## 论文
`Rethinking the Inception Architecture for Computer Vision`
- https://arxiv.org/pdf/1512.00567v3.pdf

## 模型结构

InceptionV3的整体结构由多个Inception模块组成，每个Inception模块由多个并行的卷积层和池化层组成。这些并行的卷积层和池化层的输出再被级联在一起，形成了一个高维度的特征向量，这个向量再被输入到下一个Inception模块中进行处理。

<div align=center>
     <img src="images/structure.png"/>
</div>

## 算法原理
Inception-v3 架构的使用 factorized convolutions (分解卷积) ，使用两个3x3的卷积核代替5x5的卷积核可以减少 28% 的参数量，另外分解后多使用了一个激活函数，增加了非线性表达的能力，分解示意图如下所示：

<div align=center>
     <img src="images/pic.png"/>
</div>

## 环境配置

### Docker（方法一）
此处提供[光源](https://www.sourcefind.cn/#/service-details)拉取docker镜像的地址与使用步骤，以及[光合](https://developer.sourcefind.cn/tool/)开发者社区深度学习库下载地址

```
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.1.0-ubuntu20.04-dtk24.04.2-py3.10
docker run -it --shm-size=128G -v /path/your_code_data/:/path/your_code_data/ -v /opt/hyhal:/opt/hyhal:ro --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name inceptionv3_pytorch  <your IMAGE ID> bash # <your IMAGE ID>为以上拉取的docker的镜像ID替换
```
### Dockerfile（方法二）
此处提供dockerfile的使用方法
```
docker build --no-cache -t inceptionv3:latest .
docker run -it --shm-size=128G -v /path/your_code_data/:/path/your_code_data/ -v /opt/hyhal:/opt/hyhal:ro --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name inceptionv3_pytorch bash
```
### Anaconda（方法三）
关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.sourcefind.cn/tool/)开发者社区下载安装。
```
DTK驱动：dtk24.04.2
python：python3.10
torch: 2.1.0
torchvision: 0.16.0
```
`Tips：以上dtk驱动、python、torch等DCU相关工具版本需要严格一一对应`

## 数据集

在本测试中可以使用ImageNet数据集。
数据集快速下载中心：[ImageNet2012](https://www.image-net.org/challenges/LSVRC/2012/index.php)
可参考[data/extract_ILSVRC.sh](https://developer.sourcefind.cn/codes/modelzoo/inceptionv3_pytorch/-/blob/master/data/extract_ILSVRC.sh)处理数据集，处理后数据集结构如下:
```
data
└── imagenet
    ├── train
    │   ├── n01440764
    │   │   ├── n01440764_10026.JPEG
    │   │   ├── n01440764_10027.JPEG
    ├──val
    │   ├── n01440764 
    │   │   ├── ILSVRC2012_val_00000293.JPEG
    ├── meta
    │   ├── train.txt
    │   └── val.txt
```

## 训练

训练命令：
```
    chmod +x inception_v3.sh
    ./inception_v3.sh ${isperf} ${output_json} ${ngpu}
    例如：HIP_VISIBLE_DEVICES=4,5,6,7 ./inception_v3.sh 0 output.json 4
```
${isperf}=0时，执行main.py；${isperf}=1时，执行perf.py

## result
<div align=center>
    <img src="images/result.png"/>
</div>

### 精度

测试数据使用的是ImageNet数据集，使用的加速卡是DCU Z100L。

| 卡数 |           精度            |
| :--: | :-----------------------: |
|  8   | top1:0.73888;top5:0.90528 |

## 应用场景
### 算法类别
`图像分类`
### 热点应用行业
`科研,制造,医疗,教育`

## 预训练权重
[inception_v3](https://drive.google.com/drive/folders/17ju2HN7Y6pyPK2CC_AqnAfTOe9_3hCQ8?usp=sharing)

## 源码仓库及问题反馈
- https://developer.sourcefind.cn/codes/modelzoo/inceptionv3_pytorch
## 参考资料
- https://github.com/Lornatang/InceptionV3-PyTorch.git
