#!/bin/bash


set -x

mkdir -p log
now=$(date +"%Y%m%d_%H%M%S")

isperf=$1
output_json=$2
gpu=$3

py_file="perf.py"
echo $isperf
if [ $isperf == 0 ]
then
    py_file="main.py"
fi

echo "python -m torch.distributed.run --nproc_per_node ${gpu} ${py_file} --config configs/inception.yaml --output ${output_json}"

# srun --exclusive python -u ${py_file} --config configs/inception.yaml --output ${output_json} \
# 2>&1 | tee log/train_inceptionv3.log-$now

python -m torch.distributed.run --nproc_per_node ${gpu} ${py_file} --config configs/inception.yaml --output ${output_json} 2>&1 | tee tee log/train_inceptionv3.log-$now
