# InceptionV3

## 模型介绍
InceptionV3是一种卷积神经网络模型，由Google的研究员Christian Szegedy等人在2015年提出。该模型采用了一种名为“Inception”的模块化结构，允许网络在不同的尺度上进行卷积操作，从而提高了网络的精度和效率。

## 模型结构

InceptionV3的整体结构由多个Inception模块组成，每个Inception模块由多个并行的卷积层和池化层组成。这些并行的卷积层和池化层的输出再被级联在一起，形成了一个高维度的特征向量，这个向量再被输入到下一个Inception模块中进行处理。

## 数据集
在本测试中可以使用ImageNet数据集。

## InceptionV3训练

### 环境配置

提供[光源](https://www.sourcefind.cn/#/service-details)拉取的训练以及推理的docker镜像：

* 训练镜像：docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:1.10.0-centos7.6-dtk-22.10.1-py37-latest

## 训练

将训练数据解压到data目录下。

数据快速下载中心[AIDatasets](http://113.200.138.88:18080/aidatasets)

训练命令：

    ./inception_v3.sh ${isperf} ${output_json} ${ngpu}

## 准确率数据

测试数据使用的是ImageNet数据集，使用的加速卡是DCU Z100L。

| 卡数 |           精度            |
| :--: | :-----------------------: |
|  8   | top1:0.73888;top5:0.90528 |

### 源码仓库及问题反馈

https://developer.hpccube.com/codes/modelzoo/inceptionv3_pytorch
