# ImageGenerate by paddle 
## 一、模型介绍
基于stable diffusion的网络模型实现-文生图、图生图等进行图像的生成
主要分享如何定制自己的文图生成模型，只需要几张图片，即可定制开发自己想要的文图生成模型。
文图生成任务要求模型根据所提供的描述性文本生成一张与之相对应的图片。这极大地释放了AI的想象力，也激发了人类的创意，给视觉内容创作者、文字内容创作者和大众用户带来了方便。用户可以生成多样化创意图片，并从中汲取创意灵感，打破创意瓶颈，从而可以进行创作出更优质的作品。

## 二、模型结构
文生图、图生图使用模型[MoososCap/NOVEL-MODEL]：  
默认使用该模型进行文生图、图生图等功能实现，也可切换其他模型
- MoososCap/NOVEL-MODEL pipline组成:  
    - feature_extractor/preprocessor_config.json  
    - model_index.json  
    - scheduler/scheduler_config.json  
    - text_encoder/[model_config.json,model_state.pdparams] 
    - tokenizer/[added_tokens.json,merges.txt,special_tokens_map.json,tokenizer_config.json,vocab.json]  
    - unet/[config.json,model_state.pdparams] 
    - vae/[config.json, model_state.pdparams]  
- stable diffusion网络结构
 ![模型图](./resources/pic_readme/model.png)
超分模型:  
falsr_a,falsr_b,falsr_c,falsr 三个超分模型  
[论文地址](https://arxiv.org/abs/1901.07261)  
![模型图](./resources/pic_readme/falsr_network.png)

## 三、推理和训练
### 3.1 环境配置
提供[光源](https://www.sourcefind.cn/#/service-details)拉取的训练以及推理的docker镜像：
* 3.1.1 下载推理和训练镜像：
    ```bash
    docker pull image.sourcefind.cn:5000/dcu/admin/base/paddlepaddle:2.4.2-centos7.6-dtk-23.04-py39-latest  
    ```
    * 3.1.2 python依赖安装：
    ```bash
    pip install -r requirement.txt  
    ```
### 3.2 测试
    3.2.1 测试命令：
    - 测试环境、功能是否够能够正常
    ```python
    python varify.py 
    ```

### 3.3 推理\训练代码
    3.3.1 【使用jupyter进行推理】  
    命令-jupyter：
    - 运行main.ipynb
    - 根据提示步骤运行推理、训练代码

### 3.4 使用预训练模型定制化训练图像生成模型
#### 3.4.1 预训练模型采用[MoososCap/NOVEL-MODEL]  
    命令-jupyter：
    - 运行main.ipynb
    - 根据提示步骤运行推理、训练代码
#### 3.4.2 使用starble diffusion-text_inversion方法进行训练
- 论文arxiv:[论文](https://arxiv.org/abs/2208.01618)  
- 训练过程图解：  
![训练过程](./resources/pic_readme/text_inversion.jpg)

 

## 四、生成效果 

 | 文生图  | 图生图  | 定制化训练 |
 | :----: | :-----: | :------:  |
 ![文生图](./resources/pic_readme/txt2img.jpg)  | ![图生图](./resources/pic_readme/img2img.jpg) | ![定制化训练](./resources/pic_readme/train.jpg)   
  



## 五、源码仓库及问题反馈
* https://developer.hpccube.com/codes/modelzoo/imagegenerate_paddle
## 六、参考
* https://aistudio.baidu.com/aistudio/projectdetail/4905623
