# ImageGenerate by paddle 
## 论文
`High-Resolution Image Synthesis with Latent Diffusion Models`<br>
[论文地址](https://arxiv.org/abs/2112.10752)  <br>
`Fast, Accurate and Lightweight Super-Resolution with Neural Architecture Search`<br>
[论文地址](https://arxiv.org/abs/1901.07261)  <br>
`An Image is Worth One Word: Personalizing Text-to-Image Generation using Textual Inversion`<br>
[论文地址](https://arxiv.org/abs/2208.01618)  <br>

## 模型结构
文生图、图生图使用风格化生成模型[MoososCap/NOVEL-MODEL]，核心网络为Unet，前处理网络包含text_encoder，tokenizer等。

 | stabele-Diffusion网络结构  | 超分模型网络结构  | 
 | :----: | :-----: |
 ![模型图](./resources/pic_readme/ldms.png) | ![模型图](./resources/pic_readme/falsr_network.png)   

## 算法原理
stable diffusion 对文本进行处理并进行编码生成文本向量，对初始化噪声图片添加噪声并迭代T次通过VAE_decoder网络生成最终图片
![img](./resources/pic_readme/text2img.png)

## 环境配置
### Docker（方法一）
此处提供[光源](https://www.sourcefind.cn/#/service-details)拉取docker镜像的地址与使用步骤
```
docker pull image.sourcefind.cn:5000/dcu/admin/base/paddlepaddle:2.4.2-centos7.6-dtk-23.04-py39-latest 
docker run --shm-size 16g --network=host --name=image_generate_paddle --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v $PWD/imagegenerate_paddle:/home/imagegenerate_paddle -it <Your Image ID> bash
cd imagegenerate_paddle
pip install -r requirements.txt
```
### Dockerfile（方法二）
此处提供dockerfile的使用方法
```
cd ./docker
docker build --no-cache -t imagegenerate_paddle:latest .
docker run --shm-size 16g --network=host --name=image_generate_paddle --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v $PWD/imagegenerate_paddle:/home/imagegenerate_paddle -it imagegenerate_paddle:latest bash

```
### Anaconda（方法三）
此处提供本地配置、编译的详细步骤，例如：

关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.hpccube.com/tool/)开发者社区下载安装。
```
DTK驱动：dtk23.04
python：python3.9
paddle:2.4.2
```
`Tips：以上dtk驱动、python、paddle等DCU相关工具版本需要严格一一对应`

其它非深度学习库参照requirements.txt安装：
```
pip install -r requirements.txt
```
## 数据集
`未公开训练数据集`
- 基于小数据集的定制化训练数据集
- 地址：./resources/Alices/*
```
./resources/Alices
                | 
                1666360027.7809527_SEED_3534839969.png
                1666360416.8263636_SEED_4285104386.png
                .....
```
## 推理
- 方法一：运行inference.py文件
  - ```python inference.py ```
  - 切换文生图、图生图、文生图定制化训练参考 inference文件内注释
- 方法二：使用notebook运行main.ipynb
  - 根据notebook提示运行代码
### 测试
- 测试环境、功能是否够能够正常
```python
python varify.py 
```

## result

|                                                                                                                                                                                                         文生图                                                                                                                                                                                                         |                    图生图                     |                                                             定制化训练                                                              |
|:-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------:|:------------------------------------------:|:------------------------------------------------------------------------------------------------------------------------------:|
|'prompt':'extremely detailed CG unity 8k wallpaper,black long hair,cute face,1 adult girl,happy, green skirt dress, flower pattern in dress,solo,green gown,art of light novel,in field'<br>"negative_prompt":'lowres, bad anatomy, bad hands, text, error, missing fingers, extra digit, fewer digits, cropped, worst quality, low quality, normal quality, jpeg artifacts, signature, watermark, username, blurry' |         ![图生图](./resources/cat2.jpg)          | "prompt": '<Alice> at the lake',<br>"negative_prompt": ''<br>![图生图](./resources/Alices/1666360027.7809527_SEED_3534839969.png) |
|                                                                                                                                                                                     ![文生图](./resources/pic_readme/txt2img.png)                                                                                                                                                                                      | ![图生图](./resources/pic_readme/img2img.png) |                                           ![定制化训练](./resources/pic_readme/train.png)                                           |
## 精度
无
## 应用场景
### 算法类别
`文生图,图生图,文生图定制化训练`
### 热点应用行业
`广媒,设计`
## 源码仓库及问题反馈
- https://developer.hpccube.com/codes/modelzoo/imagegenerate_paddle
## 参考资料
- https://github.com/PaddlePaddle/PaddleNLP/tree/develop/ppdiffusers
- https://aistudio.baidu.com/aistudio/projectdetail/4905623
