# IDM-VTON

## 论文

**Improving Diffusion Models for Virtual Try-on**

* https://arxiv.org/abs/2403.05139

## 模型结构

模型基于`SDXL`，使用`IP-Adapter`以及`GarmentNet`（`Unet`）提取衣物特征并加入主网络。

![alt text](readme_imgs/model_structure.png)

## 算法原理

使用`self-attention`融合低级图像特征信息，使用`cross attention`融合高级语义特征。

![alt text](readme_imgs/alg.png)


## 环境配置

### Docker（方法一）
    
    docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.1.0-centos7.6-dtk24.04-py310

    docker run --shm-size 10g --network=host --name=idmvton --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v 项目地址(绝对路径):/home/ -v /opt/hyhal:/opt/hyhal:ro -it <your IMAGE ID> bash

    pip install -r requirements.txt

    pip install bitsandbytes-0.42.0-py3-none-any.whl  （whl文件夹中）

    cd BasicSR && python setup.py develop


### Dockerfile（方法二）

    docker build -t <IMAGE_NAME>:<TAG> .

    docker run --shm-size 10g --network=host --name=idmvton --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v 项目地址(绝对路径):/home/ -v /opt/hyhal:/opt/hyhal:ro -it <your IMAGE ID> bash

    pip install -r requirements.txt

    pip install bitsandbytes-0.42.0-py3-none-any.whl  （whl文件夹中）

    cd BasicSR && python setup.py develop


### Anaconda (方法三)

1、关于本项目DCU显卡所需的特殊深度学习库可从光合开发者社区下载安装：
https://developer.hpccube.com/tool/

    DTK驱动：dtk24.04
    python：python3.10
    torch: 2.1.0
    torchvision: 0.16.0
    onnx: 1.15.0
    flash-attn: 2.0.4

Tips：以上dtk驱动、python、torch等DCU相关工具版本需要严格一一对应

2、其它非特殊库参照requirements.txt安装

    pip install -r requirements.txt

    pip install bitsandbytes-0.42.0-py3-none-any.whl  （whl文件夹中）

    cd BasicSR && python setup.py develop

## 数据集

|名称|链接|
|:---|:---|
|VITON-HD| https://github.com/shadow2496/VITON-HD |
|Dress Code|https://github.com/aimagelab/dress-code|

除了下载原始数据，该项目提供了用于测试的数据集，存放在`datasets`中。

VITON-HD

    train
    |-- ...

    test
    |-- image
    |-- image-densepose
    |-- agnostic-mask
    |-- cloth
    |-- vitonhd_test_tagged.json

DressCode

    |-- dresses
        |-- images
        |-- image-densepose
        |-- dc_caption.txt
        |-- ...
    |-- lower_body
        |-- images
        |-- image-densepose
        |-- dc_caption.txt
        |-- ...
    |-- upper_body
        |-- images
        |-- image-densepose
        |-- dc_caption.txt
        |-- ...

注意：其中image-denspose使用[detectron2](https://github.com/facebookresearch/detectron2)处理获得，具体参考 https://github.com/sangyun884/HR-VITON/issues/45 ，也可通过[原文连接](https://kaistackr-my.sharepoint.com/:u:/g/personal/cpis7_kaist_ac_kr/EaIPRG-aiRRIopz9i002FOwBDa-0-BHUKVZ7Ia5yAVVG3A?e=YxkAip)直接下载 。


## 推理

### 模型下载

[hugging-face](https://hf-mirror.com/yisol/IDM-VTON) | [SCNet](http://113.200.138.88:18080/aimodels/IDM-VTON)

[hugging-face](https://hf-mirror.com/yisol/IDM-VTON-DC) | [SCNet]()

    ckpt/
    ├── densepose
    │   └── model_final_162be9.pkl
    ├── humanparsing
    │   ├── parsing_atr.onnx
    │   └── parsing_lip.onnx
    └── openpose
        └── ckpts
            └── body_pose_model.pth
    

    pretrained_models/
    ├── dc
    │   ├── config.json
    │   └── diffusion_pytorch_model.bin
    ├── image_encoder
    │   ├── config.json
    │   └── model.safetensors
    ├── model_index.json
    ├── scheduler
    │   └── scheduler_config.json
    ├── text_encoder
    │   ├── config.json
    │   └── model.safetensors
    ├── text_encoder_2
    │   ├── config.json
    │   └── model.safetensors
    ├── tokenizer
    │   ├── merges.txt
    │   ├── special_tokens_map.json
    │   ├── tokenizer_config.json
    │   └── vocab.json
    ├── tokenizer_2
    │   ├── merges.txt
    │   ├── special_tokens_map.json
    │   ├── tokenizer_config.json
    │   └── vocab.json
    ├── unet
    │   ├── config.json
    │   └── diffusion_pytorch_model.bin
    ├── unet_encoder
    │   ├── config.json
    │   └── diffusion_pytorch_model.safetensors
    └── vae
        ├── config.json
        └── diffusion_pytorch_model.safetensors

### 命令行

#### VITON-HD

    accelerate launch inference.py \
    --width 768 --height 1024 --num_inference_steps 30 \
    --pretrained_model_name_or_path <path/to/pretrained_models> \
    --output_dir "result" \
    --unpaired \
    --data_dir <path/to/datasets/viton-hd> \
    --seed 42 \
    --test_batch_size 1 \
    --guidance_scale 2.0

#### DressCode

    accelerate launch inference_dc.py \
    --width 768 --height 1024 --num_inference_steps 30 \
    --pretrained_model_name_or_path <path/to/pretrained_models> \
    --unet_path <path/to/pretrained_models/dc> \
    --output_dir "result" \
    --unpaired \
    --data_dir <path/to/datasets/dress-code> \
    --seed 42 
    --test_batch_size 1
    --guidance_scale 2.0
    --category "upper_body" 

注意：以上默认使用多卡推理，可使用`export HIP_VISIBLE_DEVICES=<设备号>`进行限制。

### webui

    python gradio_demo/app.py

注意：需要修改`gradio_demo/app.py`中`base_path='path/to/pretrained_models'`。

## result

|model|image|cloth|prompt|result|
|:---|:---:|:---:|:---:|:---:|
|dc|![alt txt](readme_imgs/020716_0.jpg)|![alt txt](readme_imgs/020717_1.jpg)|Short Sleeves Round Neck Knit Dress|![alt txt](readme_imgs/020716_0_r.jpg)|
||![alt txt](readme_imgs/00006_00.jpg)|![alt txt](readme_imgs/00013_00.jpg)|a photo of Short Sleeve Round Neck T-shirts|![alt txt](readme_imgs/00006_00_r.jpg)|


### 精度

无

## 应用场景

### 算法类别

`AIGC`

### 热点应用行业

`零售,广媒,电商`

## 源码仓库及问题反馈

* https://developer.hpccube.com/codes/modelzoo/idm-vton_pytorch

## 参考资料

* https://github.com/yisol/IDM-VTON





