# i2vgen-xl

## 论文

**I2VGen-XL: High-Quality Image-to-Video Synthesis via Cascaded Diffusion Models**

* https://arxiv.org/abs/2311.04145

## 模型结构
该模型为两阶段的视频生成模型，其主要结构都为`3D-Unet`，其中第一阶段模型为低质量视频生成模型，其中包括提取图像高阶信息（如语义特征）的`CLIP`，图片压缩用到的`D.Enc.`（`VQGAN`中的`Encoder`）以及提取低阶特征（如细节特征）的`G.Enc.`；第二阶段模型用于生成高质量视频，以文本作为条件，第一阶段的输出进行Resize后作为LDM的输入并执行加噪去噪过程，最终得到高清视频。

![Alt text](readme_imgs/image-1.png)

## 算法原理

该算法使用了级联的方式进行视频生成，将其分为了两个过程，一个用于保证视频语义的连贯性，一个用于增强视频的细节并提高分辨率。

![alt text](readme_imgs/image-2.png)

## 环境配置

### Docker（方法一）

    docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.1.0-ubuntu20.04-dtk24.04.1-py3.10

    docker run --shm-size 10g --network=host --name=vgen --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v 项目地址(绝对路径):/home/ -v /opt/hyhal:/opt/hyhal:ro -it <your IMAGE ID> bash

    pip install -r requirements.txt

    cd xformers && pip install xformers==0.0.23 --no-deps && bash patch_xformers.rocm.sh  （whl.zip文件中）

    # 以下按需安装
    yum install epel-release -y

    yum localinstall --nogpgcheck https://download1.rpmfusion.org/free/el/rpmfusion-free-release-7.noarch.rpm -y

    yum install ffmpeg ffmpeg-devel libsm6 libxext6 -y



### Dockerfile（方法二）

    # 需要在对应的目录下
    docker build -t <IMAGE_NAME>:<TAG> .

    docker run --shm-size 10g --network=host --name=vgen --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v 项目地址(绝对路径):/home/ -v /opt/hyhal:/opt/hyhal:ro -it <your IMAGE ID> bash

    pip install -r requirements.txt

    pip install flash_attn-2.0.4_torch2.1_dtk2310-cp38-cp38-linux_x86_64.whl  （whl.zip文件中）

    pip install triton-2.1.0%2Bgit34f8189.abi0.dtk2310-cp38-cp38-manylinux2014_x86_64.whl （开发者社区下载）

    cd xformers && pip install xformers==0.0.23 --no-deps && bash patch_xformers.rocm.sh  （whl.zip文件中）

    # 以下按需安装

    yum install epel-release -y

    yum localinstall --nogpgcheck https://download1.rpmfusion.org/free/el/rpmfusion-free-release-7.noarch.rpm -y

    yum install ffmpeg ffmpeg-devel libsm6 libxext6 -y

### Anaconda (方法三)
1、关于本项目DCU显卡所需的特殊深度学习库可从光合开发者社区下载安装：
https://developer.hpccube.com/tool/

    DTK驱动：dtk23.10.1
    python：python3.8
    torch:2.1.0
    torchvision:0.16.0
    triton:2.1.0


Tips：以上dtk驱动、python、torch等DCU相关工具版本需要严格一一对应

2、其它非特殊库参照requirements.txt安装

    pip install -r requirements.txt

    cd xformers && pip install xformers==0.0.23 --no-deps && bash patch_xformers.rocm.sh  （whl.zip文件中）

    # 按需安装

    conda install -c conda-forge ffmpeg


## 数据集

作者未公开训练数据集，常用的数据集目前无法下载。

## 推理

### 命令行

    HIP_VISIBLE_DEVICES=1 python inference.py --cfg configs/i2vgen_xl_infer.yaml

    # 指定输入和模型
    HIP_VISIBLE_DEVICES=1 python inference.py --cfg configs/i2vgen_xl_infer.yaml  test_list_path data/test_list_for_i2vgen.txt test_model i2vgen-xl/i2vgen_xl_00854500.pth

test_list_path 表示输入图像路径及其对应的标题请参考演示文件 data/test_list_for_i2vgen.txt 中的特定格式和建议。test_model 是加载模型的路径。


### gradio页面

    HIP_VISIBLE_DEVICES=1 python gradio_app.py

注意：第一次执行该命令前需要创建 `workspace/experiments/test_list_for_i2vgen` 文件夹用来保存生成结果，且执行该命令会下载默认文件，当默认文件下载完毕后（程序会报错）需手动注释/删除 `~/.cache/modelscope/hub/damo/i2vgen-xl/ms_wrapper.py`中的代码

![alt text](readme_imgs/image-3.png)
        
## result

||输入|输出|
|:---|:---|:---|
|图像|![alt text](readme_imgs/img_0001.jpg)|![alt text](readme_imgs/r.gif)|
|prompt|A green frog floats on the surface of the water on green lotus leaves, with several pink lotus flowers, in a Chinese painting style.||

### 精度

无

## 应用场景

### 算法类别

`AIGC`

### 热点应用行业

`媒体,科研,教育`

## 预训练权重

[huggingface](https://huggingface.co/ali-vilab/i2vgen-xl/tree/main) | [SCNet](http://113.200.138.88:18080/aimodels/i2vgen-xl)高速通道

    i2vgen-xl/
    ├── i2vgen_xl_00854500.pth
    ├── open_clip_pytorch_model.bin
    ├── stable_diffusion_image_key_temporal_attention_x1.json
    └── v2-1_512-ema-pruned.ckpt

## 源码仓库及问题反馈

* https://developer.hpccube.com/codes/modelzoo/i2vgen-xl_pytorch

## 参考资料

* https://github.com/ali-vilab/VGen
