# HunyuanOCR
## 论文
[HunyuanOCR Technical Report](https://arxiv.org/abs/2511.19575)

## 模型简介
**HunyuanOCR**是一款基于腾讯混元原生多模态架构的端到端OCR专家模型。仅以**1B**轻量化参数，便已斩获多项业界SOTA成绩。该模型精通**复杂多语种文档解析**，同时在**文字检测识别、开放字段信息抽取、视频字幕识别、拍照翻译**等全场景实用技能中表现出色。

✨ 核心特点

- 💪 **轻量化架构**：基于混元原生多模态架构与训练策略，打造仅1B参数的OCR专项模型，大幅降低部署成本。

- 📑 **全场景功能**：单一模型覆盖文字检测和识别、复杂文档解析、卡证票据字段抽取、字幕提取等OCR经典任务，更支持端到端拍照翻译与文档问答。

- 🚀 **极致易用**：深度贯彻大模型"端到端"理念，单一指令、单次推理直达SOTA结果，较业界级联方案更高效便捷。

- 🌏 **多语种支持**：支持超过100种语言，在单语种和混合语言场景下均表现出色。

<div align="left">
  <img src="./assets/hyocr-pipeline-v1.png">
</div>
## 环境依赖

|      软件      | 版本 |
|:------------:| :------: |
|     DTK      | 25.04.2 |
|    python    | 3.10.12 |
| transformers | 4.57.1 |
|    torch     | 2.5.1+das.opt1.dtk25042 |
|  accelerate  | 1.11.0 |
| torchvision  | 0.20.1+das.opt1.dtk25042 |
推荐使用镜像:
- 挂载地址`-v`，`{docker_name}`和 `{docker_image_name}`根据实际模型情况修改

```bash
docker run -it --shm-size 200g --network=host --name {docker_name} --privileged --device=/dev/kfd --device=/dev/dri --device=/dev/mkfd --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root -v /path/your_code_path/:/path/your_code_path/ -v /opt/hyhal/:/opt/hyhal/:ro {docker_image_name} bash

示例如下：
docker run -it --shm-size 200g --network=host --name qwen3vl --privileged --device=/dev/kfd --device=/dev/dri --device=/dev/mkfd --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root -v /path/your_code_path/:/path/your_code_path/ -v /opt/hyhal/:/opt/hyhal/:ro image.sourcefind.cn:5000/dcu/admin/base/vllm:0.9.2-ubuntu22.04-dtk25.04.2-py3.10 bash
#安装特定版本的transformers
pip install git+https://github.com/huggingface/transformers@82a06db03535c49aa987719ed0746a76093b1ec4

```
更多镜像可前往[光源](https://sourcefind.cn/#/service-list)下载使用。

关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.sourcefind.cn/tool/)开发者社区下载安装，其它包参照requirements.txt安装：
```
pip install -r requirements.txt
```

## 数据集
`暂无`

## 训练
`暂无`

## 推理

### transformers
#### 单机推理
```bash
HIP_VISIBLE_DEVICES=0 python Hunyuan-OCR-master/Hunyuan-OCR-hf/run_hy_ocr.py
```

## 效果展示
**Input:**
- image:
<div align=center>
    <img src="./assets/tools-dark.png"/>
</div>

- text: "提取文档图片中正文的所有信息用markdown格式表示，其中页眉、页脚部分忽略，表格用html格式表达，文档中公式用latex格式表示，按照阅读顺序组织进行解析。"

Output:
<div align=center>
    <img src="./assets/result.png"/>
</div>


### 精度
`DCU与GPU精度一致，推理框架：transformers。`

## 预训练权重
|         模型名称         | 权重大小 | DCU型号  | 最低卡数需求 |下载地址|
|:--------------------:|:----:|:----------:|:------:|:----------:|
| HunyuanOCR |  1B  | BW1000|   1    | [Hugging Face](https://huggingface.co/tencent/HunyuanOCR) |

## 源码仓库及问题反馈
- https://developer.sourcefind.cn/codes/modelzoo/hunyuanocr_pytorch

## 参考资料
- https://github.com/Tencent-Hunyuan/HunyuanOCR
