# HRNet_PyTorch

## 模型介绍

HRNet（High-Resolution Network）是一种用于图像识别的神经网络架构，由中国香港科学与技术大学的研究团队于2019年提出。HRNet旨在解决传统神经网络在处理高分辨率图像时出现的精度损失和计算效率低下的问题。

相比于传统的卷积神经网络（CNN），HRNet采用了一种新的多尺度融合方法，使得网络可以同时保留高分辨率的细节信息和低分辨率的全局信息，从而更好地捕捉图像中的语义信息。此外，HRNet还采用了一种高效的并行计算方式，可以显著减少训练和推理的时间和计算资源成本。

HRNet在多项图像识别任务上都取得了较好的结果，包括人体姿态估计、人脸识别、图像分割等。由于其出色的性能和效率，HRNet已经成为了深度学习领域中备受关注的研究方向之一。

## 模型结构

HRNet的模型结构主要包括四个阶段：

1. 基础阶段（Base Stage）：该阶段采用了与传统的卷积神经网络相似的结构，包括多个卷积层和池化层，用于从原始输入图像中提取特征。
2. 多尺度融合阶段（Multi-Scale Fusion Stage）：该阶段采用了一种多分辨率的特征融合方式，将来自不同分辨率的特征图进行融合，以获得具有高分辨率细节信息和低分辨率全局信息的特征图。
3. 融合阶段（Fusion Stage）：该阶段将来自多个分辨率的特征图进行融合，以得到更加丰富和准确的特征表示。
4. 分类阶段（Classification Stage）：该阶段采用全局平均池化和全连接层对特征进行分类，输出最终的预测结果。

HRNet的模型结构具有高度的灵活性，可以根据不同的任务和数据集进行调整和优化。此外，HRNet还采用了一种并行计算方式，可以显著提高训练和推理的效率。



## 数据集

COCO2017（Common Objects in Context）是一个广泛使用的图像识别与分割数据集，由微软研究院于2014年开始构建，目的是为图像理解和计算机视觉领域提供一个更具挑战性和多样化的数据集。

COCO2017数据集包含超过33万张图像，涵盖了80个不同类别的物体，如人、动物、交通工具、家具等，并提供了每个物体的详细注释，包括物体的边框、类别和关键点等信息。此外，COCO2017还提供了场景分类、图像标注和图像题解等多个任务的数据。

COCO2017数据集的挑战在于其图像具有较高的复杂性和多样性，包括遮挡、变形、多姿态、多物体等情况，对图像理解和计算机视觉的算法提出了更高的要求。因此，COCO2017数据集已经成为了图像识别、物体检测、图像分割和场景理解等领域中广泛使用的基准数据集之一。

COCO2017数据集可以通过如下链接进行下载

http://images.cocodataset.org/zips/train2017.zip   \# 19G, 118k images

http://images.cocodataset.org/zips/val2017.zip   \# 1G, 5k images

http://images.cocodataset.org/zips/test2017.zip   \# 7G, 41k images (optional)



## 训练及推理

### 环境配置

```
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:1.10.0-centos7.6-dtk-22.10-py38-latest
```

安装如下三方库

```
xtcocotools==1.13
json-tricks==3.16.1
munkres==1.1.4
matplotlib-inline==0.1.6
chumpy==0.70
```

在mmpost目录下执行

```
pip install -e .
```



使用数据集：coco

在mmpose目录下创建data文件夹并创建coco数据集软链接

```
mkdir data

cd data

ln -s /path/COCO2017/ coco
```



## 准确率数据

| 卡数 |         精度         |
| :--: | :------------------: |
|  4   | AP=0.6504；AR=0.7086 |

## 源码仓库及问题反馈

http://developer.hpccube.com/codes/modelzoo/hrnet_pytorch.git

## 参考

https://github.com/open-mmlab/mmpose/blob/master/configs/body/2d_kpt_sview_rgb_img/cid/coco/hrnet_w32_coco_512x512.py