# HRNet_PyTorch
## 论文
`Deep High-Resolution Representation Learning for Human Pose Estimation`

- [https://arxiv.org/pdf/1902.09212.pdf](https://arxiv.org/pdf/1902.09212.pdf)
## 模型结构
HRnet模型是一种多分支的卷积神经网络结构，通过在不同分辨率的特征图之间进行信息交互和融合，实现了高效的人体姿态估计任务。

![hrnet_1](hrnet_1.jpg)


## 算法原理
HRnet模型通过构建多分支的卷积神经网络，在不同层级的特征图之间进行信息交互和融合，利用分层特征的高分辨率和全局上下文信息，实现了准确的人体姿态估计。

![hrnet_2](hrnet_2.jpg)


## 环境配置
### Docker（方法一）
此处提供[光源](https://www.sourcefind.cn/#/service-details)拉取docker镜像的地址与使用步骤
```
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:1.10.0-centos7.6-dtk-22.10-py38-latest

docker run -it -v /path/your_code_data/:/path/your_code_data/ --shm-size=32G --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name docker_name imageID bash

pip3 install -r requirements.txt
```
### Dockerfile（方法二）
此处提供dockerfile的使用方法
```
cd ./docker
docker build --no-cache -t hrnet:1.0 .
docker run -it -v /path/your_code_data/:/path/your_code_data/ --shm-size=32G --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name docker_name imageID bash

pip3 install -r requirements.txt
```
### Anaconda（方法三）
此处提供本地配置、编译的详细步骤，例如：

关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.hpccube.com/tool/)开发者社区下载安装。
```
DTK驱动：dtk22.10
python：python3.8
torch：1.10
torchvision：0.10
mmcv-full：1.6.1+gitdebbc80.dtk2210
```
`Tips：以上dtk驱动、python、paddle等DCU相关工具版本需要严格一一对应`

此外安装如下三方库

```
pip3 install -r conda_requirement.txt
```



## 数据集
`COCO2017`

[训练数据](http://images.cocodataset.org/zips/train2017.zip)

[验证数据](http://images.cocodataset.org/zips/val2017.zip)

[测试数据](http://images.cocodataset.org/zips/test2017.zip)

[标签数据](https://github.com/ultralytics/yolov5/releases/download/v1.0/coco2017labels.zip)

数据集的目录结构如下：

```
├── images 
│   ├── train2017
│   ├── val2017
│   ├── test2017
├── labels
│   ├── train2017
│   ├── val2017
├── annotations
│   ├── person_keypoints_train2017.json
│   ├── person_keypoints_val2017.json
│   ├── captions_train2017.json
│   ├── captions_val2017.json
│   ├── instances_train2017.json
│   ├── instances_val2017.json
├── LICENSE
├── README.txt 
├── test-dev2017.txt
├── train2017.txt
├── val2017.txt

```

## 训练
在mmpost目录下执行

```
pip3 install -e .
```

之后在训练脚本中--cfg-options后面修改data_root值和train，val，test中ann_file的路径

### 单机多卡
```
bash train.sh
#默认为4卡，若需要调整卡数，请修改HIP_VISIBLE_DEVICES的值
```

## result

<img src="https://user-images.githubusercontent.com/15977946/173139730-32ce89a0-9a09-4f07-b39f-8e794a8b2630.gif" height="270px" alt>


### 精度
测试数据：COCO2017，使用的加速卡:Z100L。

根据测试结果情况填写表格：
| 卡数 | 准确率 |
| :------: | :------: |
| 4 | AP=0.6504；AR=0.7086 |
## 应用场景
### 算法类别
`姿态估计`

### 热点应用行业
`交通,政府,家居`

## 源码仓库及问题反馈
- [https://developer.hpccube.com/codes/modelzoo/hrnet_pytorch](https://developer.hpccube.com/codes/modelzoo/hrnet_pytorch)
## 参考资料
- https://github.com/open-mmlab/mmpose/blob/master/configs/body/2d_kpt_sview_rgb_img/cid/coco/hrnet_w32_coco_512x512.py
