# Hermes-4.3
## 论文
[Hermes-4.3](https://arxiv.org/pdf/2508.18255)

## 模型简介
Hermes-4.3-36B是一款基于字节跳动Seed-36B底座开发的前沿混合推理模型，Hermes-4.3相比Hermes-3的创新如下：  
- 后训练数据规模：样本量从100万（12亿tokens）扩展至约500万样本（约600亿tokens），融合推理与非推理数据   
- 混合推理模式：支持显式使用 <think>…</think> 标签进行思考推演，同时提供快速响应选项    
- 高质量表达性推理：显著提升数学计算、编程、STEM、逻辑推理乃至创意写作与主观应答能力    
- 格式遵循与结构化输出：训练生成符合预设模式的合规JSON，并具备修复异常数据结构的能力   
- 更强的引导性与对齐性：在可引导性方面实现跨越式进步，尤其体现在显著降低的拒绝响应率
## 环境依赖

| 软件 | 版本 |
| :------: | :------: |
| DTK | 25.04.2 |
| python | 3.10.12 |
| transformers | >=4.57.1 |
| vllm | 0.11.0+das.opt1.alpha.dtk25042.20251225.gca4598a4 |
| torch | 2.5.1+das.opt1.dtk25042 |
| triton | 3.1.0+das.opt1.dtk25042.20251224.gaa867475 |


推荐使用镜像:harbor.sourcefind.cn:5443/dcu/admin/base/vllm:0.11.0-ubuntu22.04-dtk25.04.2-tx-1226-das1.7-py3.10-20251226
- 挂载地址`-v`根据实际模型情况修改

```bash
docker run -it --shm-size 60g --network=host --name Hermes --privileged --device=/dev/kfd --device=/dev/dri --device=/dev/mkfd --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root -v /opt/hyhal/:/opt/hyhal/:ro -v /path/your_code_path/:/path/your_code_path/  harbor.sourcefind.cn:5443/dcu/admin/base/vllm:0.11.0-ubuntu22.04-dtk25.04.2-tx-1226-das1.7-py3.10-20251226 bash
```
更多镜像可前往[光源](https://sourcefind.cn/#/service-list)下载使用。

关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.sourcefind.cn/tool/)开发者社区下载安装。

## 数据集
暂无

## 训练
暂无

## 推理

### vllm
#### 单机推理

```bash
## serve启动
可参考vllm_serve.sh脚本
vllm serve NousResearch/Hermes-4.3-36B  --trust-remote-code --dtype bfloat16  -tp 2  --max-model-len 32768 --port 8010
## client访问
可参考vllm_cilent.sh
curl -X POST "http://localhost:8010/v1/chat/completions"      -H "Content-Type: application/json"     --data '{
                "model": "NousResearch/Hermes-4.3-36B",
                "messages": [
                        {
                                "role": "user",
                                "content": "请介绍下自己"
                        }
                ]
        }'

```

## 效果展示
<div align=center>
    <img src="./doc/result.png"/>
</div>

### 精度
DCU与GPU精度一致，推理框架：vllm。

## 预训练权重
| 模型名称  | 权重大小  | DCU型号  | 最低卡数需求 |下载地址|
|:-----:|:----------:|:----------:|:---------------------:|:----------:|
| Hermes-4.3-36B | 36B | K100AI | 2 | [下载地址](https://huggingface.co/NousResearch/Hermes-4.3-36B) |

## 源码仓库及问题反馈
- https://developer.sourcefind.cn/codes/modelzoo/hermes-4.3_vllm

## 参考资料
- https://nousresearch.com/introducing-hermes-4-3/
