# HDETR
## 论文
`DETRs with Hybrid Matching`
- https://arxiv.org/abs/2207.13080

## 模型结构
基于DETR结构，在匹配阶段加入一对多的匹配分支。

<div align=center>
    <img src="./doc/hybrid.png"/>
</div>

## 算法原理
H-DETR引入一对多匹配分支，将原始的一对一匹配分支与一个辅助的一对多匹配分支结合起来，允许多个查询分配给每个正样本，增加正样本查询数量，提高训练效果。此外，H-DETR在推理过程中仍然使用原始的一对一匹配分支，以保持DETR的优势。

<div align=center>
    <img src="./doc/methods.png"/>
</div>

## 环境配置
### Docker（方法一）
-v 路径、docker_name和imageID根据实际情况修改

```bash
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.1.0-ubuntu20.04-dtk24.04.1-py3.10
docker run -it -v /path/your_code_data/:/path/your_code_data/ --shm-size=80G --privileged=true --device=/dev/kfd --device=/dev/dri/ -v /opt/hyhal:/opt/hyhal:ro --group-add video --name docker_name imageID bash

cd /your_code_path/hdetr_pytorch
pip install -r requirements.txt

pip install openmim
mim install mmcv-full  （注意版本是不是1.7.1）
pip install mmdet==2.26.0 （对应mmcv 1.7.1）
```

### Dockerfile（方法二）
-v 路径、docker_name和imageID根据实际情况修改
```bash
cd ./docker

docker build --no-cache -t hdetr:latest .
docker run -it -v /path/your_code_data/:/path/your_code_data/ --shm-size=80G --privileged=true --device=/dev/kfd --device=/dev/dri/ -v /opt/hyhal:/opt/hyhal:ro --group-add video --name docker_name imageID bash

cd /your_code_path/hdetr_pytorch
pip install -r requirements.txt

pip install openmim
mim install mmcv-full  （注意版本是不是1.7.1）
pip install mmdet==2.26.0 （对应mmcv 1.7.1）
```

### Anaconda（方法三）
关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.hpccube.com/tool/)开发者社区下载安装。
```bash
DTK软件栈: dtk23.04.1
python: python3.10
torch: 2.1.0
torchvision: 0.16.0
```
`Tips:以上dtk软件栈、python、torch等DCU相关工具版本需要严格一一对应`

其他非特殊库直接按照requirements.txt安装:
```bash
pip install -r requirements.txt

pip install openmim
mim install mmcv-full  （注意版本是不是1.7.1）
pip install mmdet==2.26.0 （对应mmcv 1.7.1）
```

## 数据集
通过SCNet下载[COCO2017](https://cocodataset.org/#home)所需数据集。

数据集的目录结构如下:

```
├── COCO2017
│   ├── train2017
│   ├── val2017
│   ├── test2017
│   ├── annotations
│       ├── instances_train2017.json
│       └── instances_val2017.json
```

训练/验证集数据准备：训练/验证集都是采用的**COCO**的数据格式，如果使用自己的标注数据，请先将标注数据转换成**COCO**的格式，并按照上面的目录结构进行存放。

本项目提供了`coco128`数据集可以进行功能验证使用，目录结构如下：
```bash
├── coco128
│   ├── train2017
│   ├── val2017
│   └── annotations
│       └── instances_train2017.json
```

## 训练
1. 训练之前，需要进行下面步骤编译：
```bash
cd ./models/ops
bash ./make.sh
cd ../../
```

2. 选择需要训练的模型的config，`<config path>`为需要训练的模型属性config文件地址，`<coco path>`为当前环境中训练数据对应地址；

3. 其他：
+ 如果有预训练模型，修改config中的`--pretrained_backbone_path`为保存的预训练模型地址，预训练模型可从[#预训练权重](#预训练权重)中；
+ 当前训练默认backbone为`R50`，如果使用backbone为`swin`，可前往[Swin-Transformer](https://github.com/microsoft/Swin-Transformer)择对应的预训练模型后再进行训练步骤；
+ 如果out_of_memory，设置`--batch_size`大小，当前默认为2。
4. 如果想要使用单卡训练，将train_multi.sh的多卡设置为1，启动单卡即可。

### 单机单卡/多卡
```bash
bash ./train_multi.sh
```

## 推理
1. 验证前需提前准备好预训练模型，可从[#预训练权重](#预训练权重)中提供的模型下载，`<checkpoint path>`为模型地址，`<coco path>`为当前环境中推理数据的对应地址，数据应为COCO数据格式。[#预训练权重](#预训练权重)中提供的模型下载，选择模型对应的config后进行效果验证。

2. 如果想要查看预测效果（预测结果输出到图片上），请执行(其余参数与训练config参数需一致，详情请参考代码里面的参数配置):

3. 执行：
```bash
python test.py --pre_trained_model <checkpoint path> --coco_path <coco path>
```
以[r50_hybrid_branch_lambda1_group6_t1500_dp0_mqs_lft_deformable_detr_plus_iterative_bbox_refinement_plus_plus_two_stage_12eps.pth](https://github.com/HDETR/H-Deformable-DETR/releases/download/v0.1/r50_hybrid_branch_lambda1_group6_t1500_dp0_mqs_lft_deformable_detr_plus_iterative_bbox_refinement_plus_plus_two_stage_12eps.pth)模型为例：
```bash
python test.py --pre_trained_model /path/r50_hybrid_branch_lambda1_group6_t1500_dp0_mqs_lft_deformable_detr_plus_iterative_bbox_refinement_plus_plus_two_stage_12eps.pth --coco_path /path/coco/data --two_stage --num_queries_one2many 1500 --mixed_selection --look_forward_twice
```

#### 多卡推理
```bash
bash val_multi.sh
```

## result
COCO2017测试集上的单张图像结果展示:

<div align=center>
    <img src="./doc/results.jpg"/>
</div>

### 精度
测试数据：COCO-test2017，测试模型config:[r50_hybrid_branch_lambda1_group6_t1500_dp0_mqs_lft_deformable_detr_plus_iterative_bbox_refinement_plus_plus_two_stage.sh](./configs/two_stage/deformable-detr-hybrid-branch/12eps/r50_hybrid_branch_lambda1_group6_t1500_dp0_mqs_lft_deformable_detr_plus_iterative_bbox_refinement_plus_plus_two_stage.sh)

结果如下表所示:
| Device | Backbone | query | epochs | AP |
| :--------: | :------: | :------: | :------: | :------: |
| Z100L | R50 | 300 | 12 | 48.6 |
| V100S | R50 | 300 | 12 | 48.7 |

## 应用场景
### 算法类别
目标检测

### 热点应用行业
网安,交通,政府

## 预训练权重
- [r50_hybrid_branch_lambda1_group6_t1500_dp0_mqs_lft_deformable_detr_plus_iterative_bbox_refinement_plus_plus_two_stage_12eps](https://github.com/HDETR/H-Deformable-DETR/releases/download/v0.1/r50_hybrid_branch_lambda1_group6_t1500_dp0_mqs_lft_deformable_detr_plus_iterative_bbox_refinement_plus_plus_two_stage_12eps.pth)

## 源码仓库及问题反馈
- https://developer.hpccube.com/codes/modelzoo/hdetr_pytorch

## 参考资料
- https://github.com/HDETR/H-Deformable-DETR
