#!/bin/bash
# NCCL相关的DEBUG信息显示
export NCCL_DEBUG=INFO

export HSA_FORCE_FINE_GRAIN_PCIE=1
export NCCL_P2P_LEVEL=5

export WORLD_SIZE=$OMPI_COMM_WORLD_SIZE
export NCCL_PLUGIN_P2P=ucx
export NCCL_SHM_DISABLE=1
export NCCL_IB_DISABLE=0 #不适用ib
export NCCL_IB_HCA=mlx5_0
export NCCL_CROSS_NIC=1
export RCCL_NCHANNELS=4
export MASTER_ADDR=$dist_url
export MASTER_PORT=4321
export RANK=$OMPI_COMM_WORLD_RANK
export NCCL_SOCKET_IFNAME=ib0

lrank=$OMPI_COMM_WORLD_LOCAL_RANK

# 待训练yaml文件地址
YAML='options/train/train_HAT_SRx4_finetune_from_ImageNet_pretrain.yml'
APP="python3 -u hat/train.py -opt ${YAML} --launcher pytorch "

case ${lrank} in
[0])
  export HIP_VISIBLE_DEVICES=0,1,2,3,4,5,6,7
  export UCX_NET_DEVICES=mlx5_0:1
  export UCX_IB_PCI_BW=mlx5_0:50Gbs
  numactl --cpunodebind=0 --membind=0 ${APP}
  ;;
[1])
  export HIP_VISIBLE_DEVICES=0,1,2,3,4,5,6,7
  export UCX_NET_DEVICES=mlx5_1:1
  export UCX_IB_PCI_BW=mlx5_1:50Gbs
  numactl --cpunodebind=0 --membind=0 ${APP}
  ;;
[2])
  export HIP_VISIBLE_DEVICES=0,1,2,3,4,5,6,7
  export UCX_NET_DEVICES=mlx5_2:1
  export UCX_IB_PCI_BW=mlx5_2:50Gbs
  numactl --cpunodebind=0 --membind=0 ${APP}
  ;;
[3])
  export HIP_VISIBLE_DEVICES=0,1,2,3,4,5,6,7
  export UCX_NET_DEVICES=mlx5_3:1
  export UCX_IB_PCI_BW=mlx5_3:50Gbs
  numactl --cpunodebind=0 --membind=0 ${APP}
  ;;
[4])
  export HIP_VISIBLE_DEVICES=0,1,2,3,4,5,6,7
  export UCX_NET_DEVICES=mlx5_4:1
  export UCX_IB_PCI_BW=mlx5_4:50Gbs
  numactl --cpunodebind=3 --membind=3 ${APP}
  ;;
[5])
  export HIP_VISIBLE_DEVICES=0,1,2,3,4,5,6,7
  export UCX_NET_DEVICES=mlx5_5:1
  export UCX_IB_PCI_BW=mlx5_5:50Gbs
  numactl --cpunodebind=3 --membind=3 ${APP}
  ;;
[6])
  export HIP_VISIBLE_DEVICES=0,1,2,3,4,5,6,7
  export UCX_NET_DEVICES=mlx5_6:1
  export UCX_IB_PCI_BW=mlx5_6:50Gbs
  numactl --cpunodebind=3 --membind=3 ${APP}
  ;;
[7])
  export HIP_VISIBLE_DEVICES=0,1,2,3,4,5,6,7
  export UCX_NET_DEVICES=mlx5_7:1
  export UCX_IB_PCI_BW=mlx5_7:50Gbs
  numactl --cpunodebind=3 --membind=3 ${APP}
  ;;
esac
