import os
import cv2
import argparse

parser = argparse.ArgumentParser('gen BSD/urban100 LRbicx4', add_help=False)
parser.add_argument('--file_name', default='', type=str, help='Name of image file')
args = parser.parse_args()


if __name__ == "__main__":
    root_path = './{}'.format(args.file_name)
    GT_images_path = os.path.join(root_path, 'GTmod4')
    LR_images_path = os.path.join(root_path, 'LRbicx4')

    for img_name in os.listdir(GT_images_path):

        img_path = os.path.join(GT_images_path, img_name)
        print("img_path", img_path)
        save_path = os.path.join(LR_images_path, img_name)
        img = cv2.imread(img_path)
        if img is None:
            print("empty!!!!!", img_path)
            continue
        resize_width = int(img.shape[1]/4)
        resize_height = int(img.shape[0]/4)
        print("original size {} resize size {}".format(img.shape, (resize_width, resize_height)))
        img_resize = cv2.resize(img, (resize_width, resize_height), interpolation = cv2.INTER_AREA)

        cv2.imwrite(save_path, img_resize)
    print("processing end.")