# Generative Pre-Training2(GPT2)

## 模型介绍
GPT2模型：第二代生成式预训练模型（Generative Pre-Training2）。

## 模型结构
GPT2主要使用Transformer的Decoder模块为特征提取器，并对Transformer Decoder进行了一些改动，原本的Decoder包含了两个Multi-Head Attention结构，而GPT2只保留了Mask Multi-Head Attention。

## Python版本推理

本次采用GPT-2模型进行诗词生成任务，模型文件下载链接：https://pan.baidu.com/s/1KWeoUuakCZ5dualK69qCcw , 提取码：4pmh ，并将GPT2_shici.onnx模型文件保存在model文件夹下。下面介绍如何运行python代码示例，具体推理代码解析，在Doc/Tutorial_Python目录中有详细说明。

### 安装镜像

在光源可拉取推理的docker镜像，GPT2模型推理的镜像如下： 

```python
docker pull image.sourcefind.cn:5000/dcu/admin/base/custom:ort1.14.0_migraphx3.0.0-dtk22.10.1
```

### 执行推理

1.参考《MIGraphX教程》中的安装方法安装MIGraphX并设置好PYTHONPATH

2.安装依赖：

```python
# 进入migraphx samples工程根目录
cd <path_to_migraphx_samples> 

# 进入示例程序目录
cd ./Python/

# 安装依赖
pip install -r requirements.txt
```

3.设置环境变量：

```python
# 设置动态shape模式
export MIGRAPHX_DYNAMIC_SHAPE=1
```

4.在Python/NLP/GPT2目录下执行如下命令运行该示例程序：

```python
python gpt2.py
```

如下所示，采用交互式界面，通过输入开头诗词，GPT2模型可以生成后续的诗句。

<img src="./Doc/Images/GPT_03.png" style="zoom:80%;" align=middle>

## C++版本推理

下面介绍如何运行python代码示例，具体推理代码解析，在Doc/Tutorial_Cpp目录中有详细说明。

参考Python版本推理中的构建安装，在光源中拉取推理的docker镜像。

### 修改CMakeLists.txt

- 如果使用ubuntu系统，需要修改CMakeLists.txt中依赖库路径：
  将"${CMAKE_CURRENT_SOURCE_DIR}/depend/lib64/"修改为"${CMAKE_CURRENT_SOURCE_DIR}/depend/lib/"

- **MIGraphX2.3.0及以上版本需要c++17**


### 构建工程

```
rbuild build -d depend
```

### 设置环境变量

将依赖库依赖加入环境变量LD_LIBRARY_PATH，在~/.bashrc中添加如下语句：

**Centos**:

```
export LD_LIBRARY_PATH=<path_to_migraphx_samples>/depend/lib64/:$LD_LIBRARY_PATH
```

**Ubuntu**:

```
export LD_LIBRARY_PATH=<path_to_migraphx_samples>/depend/lib/:$LD_LIBRARY_PATH
```

然后执行:

```
source ~/.bashrc
```

### 执行推理

运行GPT2示例程序，具体执行如下命令：

```python
# 进入migraphx samples工程根目录
cd <path_to_migraphx_samples> 

# 进入build目录
cd ./build/

# 设置动态shape模式
export MIGRAPHX_DYNAMIC_SHAPE=1

# 执行示例程序
./GPT2
```

如下所示，采用交互式界面，通过输入开头诗词，GPT2模型可以推理出后续的诗句。

<img src="./Doc/Images/GPT_04.png" style="zoom:100%;" align=middle>

## 历史版本

https://developer.hpccube.com/codes/modelzoo/gpt2_migraphx

## 参考资料

https://github.com/yangjianxin1/GPT2-chitchat

https://github.com/Morizeyao/GPT2-Chinese