# Generative Pre-Training2(GPT2)

## 模型介绍
GPT2模型：第二代生成式预训练模型（Generative Pre-Training2）。

## 模型结构
GPT2主要使用Transformer的Decoder模块为特征提取器，并对Transformer Decoder进行了一些改动，原本的Decoder包含了两个Multi-Head Attention结构，而GPT2只保留了Mask Multi-Head Attention。

## Python版本推理

本次采用GPT-2模型进行诗词生成任务，模型文件下载链接：https://pan.baidu.com/s/1KWeoUuakCZ5dualK69qCcw , 提取码：4pmh ，并将GPT2_shici.onnx模型文件保存在Resource/文件夹下。下面介绍如何运行python代码示例，Python示例的详细说明见Doc目录下的Tutorial_Python.md。

### 下载镜像

在光源中下载MIGraphX镜像： 

```python
docker pull image.sourcefind.cn:5000/dcu/admin/base/custom:ort1.14.0_migraphx3.0.0-dtk22.10.1
```

### 设置Python环境变量

```
export PYTHONPATH=/opt/dtk/lib:$PYTHONPATH
```

### 安装依赖

```python
# 进入gpt2 migraphx工程根目录
cd <path_to_gpt2_migraphx> 

# 进入示例程序目录
cd Python/

# 安装依赖
pip install -r requirements.txt
```

### 运行示例

```python
python gpt2.py
```

如下所示，采用交互式界面，通过输入开头诗词，GPT2模型可以生成后续的诗句。

```
user:江上归帆天际开
chatbot:江上归帆天际开，江头别棹日边回。风尘满地音书绝，鸿雁不来春又来。
user:我亦孤山冷淡郎
chatbot:我亦孤山冷淡郎，爱梅不作一般香。水边篱落坡仙笑，羔酒空浇入甲黄。
user:七言绝句
chatbot:七言绝句古无有，五字长城今在前。我欲从君乞妙语，笔端三昧要亲传。
user:春风吹絮满江南
chatbot:春风吹絮满江南，一片离情酒半酣。记得小桥和雪看，梅花无数簇晴岚。
```

## C++版本推理

本次采用GPT-2模型进行诗词生成任务，模型文件下载链接：https://pan.baidu.com/s/1KWeoUuakCZ5dualK69qCcw , 提取码：4pmh ，并将GPT2_shici.onnx模型文件保存在Resource/文件夹下。下面介绍如何运行C++代码示例，C++示例的详细说明见Doc目录下的Tutorial_Cpp.md。

### 下载镜像

```
docker pull image.sourcefind.cn:5000/dcu/admin/base/custom:ort1.14.0_migraphx3.0.0-dtk22.10.1
```


### 构建工程

```
rbuild build -d depend
```

### 设置环境变量

将依赖库依赖加入环境变量LD_LIBRARY_PATH，在~/.bashrc中添加如下语句：

```
export LD_LIBRARY_PATH=<path_to_gpt2_migraphx>/depend/lib64/:$LD_LIBRARY_PATH
```

然后执行:

```
source ~/.bashrc
```

### 运行示例

```python
# 进入gpt2 migraphx工程根目录
cd <path_to_gpt2_migraphx> 

# 进入build目录
cd build/

# 执行示例程序
./GPT2
```

如下所示，采用交互式界面，通过输入开头诗词，GPT2模型可以推理出后续的诗句。

```
question：江上归帆天际开
chatbot：江上归帆天际开，江头别棹日边回。风尘满地音书绝，鸿雁不来春又来。
question：我亦孤山冷淡郎
chatbot：我亦孤山冷淡郎，爱梅不作一般香。水边篱落坡仙笑，羔酒空浇入甲黄。
question：七言绝句
chatbot：七言绝句古无有，五字长城今在前。我欲从君乞妙语，笔端三昧要亲传。
question：春风吹絮满江南
chatbot：春风吹絮满江南，一片离情酒半酣。记得小桥和雪看，梅花无数簇晴岚。
```

## 源码仓库及问题反馈

https://developer.hpccube.com/codes/modelzoo/gpt2_migraphx

## 参考

https://github.com/Morizeyao/GPT2-Chinese