# GPT2

## 论文
Language Models are Unsupervised Multitask Learners

- https://d4mucfpksywv.cloudfront.net/better-language-models/language-models.pdf

## 模型结构
第二代生成式预训练模型（Generative Pre-Training2），GPT2主要使用Transformer的Decoder模块为特征提取器，并对Transformer Decoder进行了一些改动，原本的Decoder包含了两个Multi-Head Attention结构，而GPT2只保留了Mask Multi-Head Attention。

<img src="./Doc/Images/GPT_03.png" style="zoom:55%;" align=middle>

## 算法原理

GPT-2中使用了掩模自注意力(masked self-attention)，通过屏蔽当前位置的右边token，使模型可以更好的预测下一个token。

<img src="./Doc/Images/GPT_04.png" style="zoom:70%;" align=middle>

## 环境配置

### Docker（方法一）

拉取镜像：

```
docker pull image.sourcefind.cn:5000/dcu/admin/base/migraphx:4.3.0-ubuntu20.04-dtk24.04.1-py3.10
```

创建并启动容器，安装相关依赖：

```
docker run --shm-size 16g --network=host --name=gpt2_migraphx --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v $PWD/gpt2_migraphx:/home/gpt2_migraphx -v /opt/hyhal:/opt/hyhal:ro -it <Your Image ID> /bin/bash

# 激活dtk
source /opt/dtk/env.sh
```

### Dockerfile（方法二）

```
cd ./docker
docker build --no-cache -t gpt2_migraphx:2.0 .

docker run --shm-size 16g --network=host --name=gpt2_migraphx --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v $PWD/gpt2_migraphx:/home/gpt2_migraphx -v /opt/hyhal:/opt/hyhal:ro -it <Your Image ID> /bin/bash

# 激活dtk
source /opt/dtk/env.sh
```

## 数据集

采用交互式界面，通过输入开头诗词，GPT2模型可以推理出后续的诗句。

## 推理

### Python版本推理

本次采用GPT-2模型进行诗词生成任务，模型文件下载链接：https://pan.baidu.com/s/1KWeoUuakCZ5dualK69qCcw , 提取码：4pmh ，并将GPT2_shici.onnx模型文件保存在Resource/文件夹下。下面介绍如何运行python代码示例，Python示例的详细说明见Doc目录下的Tutorial_Python.md。

#### 设置环境变量

```
export PYTHONPATH=/opt/dtk/lib:$PYTHONPATH
```

#### 运行示例

```
# 进入gpt2 migraphx工程根目录
cd <path_to_gpt2_migraphx> 

# 进入示例程序目录
cd Python/

# 安装依赖
pip install -r requirements.txt -i https://pypi.tuna.tsinghua.edu.cn/simple

# 运行示例
python gpt2.py
```

### C++版本推理

本次采用GPT-2模型进行诗词生成任务，模型文件下载链接：https://pan.baidu.com/s/1KWeoUuakCZ5dualK69qCcw , 提取码：4pmh ，并将GPT2_shici.onnx模型文件保存在Resource/文件夹下。下面介绍如何运行C++代码示例，C++示例的详细说明见Doc目录下的Tutorial_Cpp.md。

#### 构建工程

```
rbuild build -d depend
```

#### 设置环境变量

将依赖库依赖加入环境变量LD_LIBRARY_PATH，在~/.bashrc中添加如下语句：

```
export LD_LIBRARY_PATH=<path_to_gpt2_migraphx>/depend/lib/:$LD_LIBRARY_PATH
```

然后执行:

```
source ~/.bashrc
```

#### 运行示例

```python
# 进入gpt2 migraphx工程根目录
cd <path_to_gpt2_migraphx> 

# 进入build目录
cd build/

# 执行示例程序
./GPT2
```

## result

### python版本

<img src="./Doc/Images/result_Python.png" style="zoom:70%;" align=middle>

### C++版本

<img src="./Doc/Images/result_C++.png" style="zoom:70%;" align=middle>

## 应用场景

### 算法类别

`对话问答`

### 热点应用行业

`政府`,`零售`,`教育`,`科研`

## 源码仓库及问题反馈

https://developer.sourcefind.cn/codes/modelzoo/gpt2_migraphx

## 参考资料

https://github.com/Morizeyao/GPT2-Chinese
