#ifndef GPT2_H
#define GPT2_H

#include <cstdint>
#include <string>
#include <migraphx/program.hpp>
#include <CommonDefinition.h>
#include <tokenization.h>
using namespace cuBERT;

namespace migraphxSamples
{
    typedef struct _Predictions
    {
        long unsigned int index;
        float predictionvalue;
    }Predictions;

class GPT2
{

public:
    GPT2();
    
    ~GPT2();

    ErrorCode Initialize(InitializationParameterOfNLP initParamOfNLPGPT2);

    ErrorCode Preprocessing(cuBERT::FullTokenizer tokenizer,
                             char *question,
                             std::vector<long unsigned int> &input_id);

    long unsigned int Inference(const std::vector<long unsigned int> &input_id);

private:
    ErrorCode DoCommonInitialization(InitializationParameterOfNLP initParamOfNLPGPT2);

private:
    FILE *logFile;
    cv::FileStorage configurationFile;
    InitializationParameterOfNLP initializationParameter;

    migraphx::program net;
    std::string inputName;
    migraphx::shape inputShape;
};

}
#endif