# Generative Pre-Training2(GPT2)

## 模型介绍
GPT2模型：第二代生成式预训练模型（Generative Pre-Training2）。

## 模型结构
GPT2主要使用Transformer的Decoder模块为特征提取器，并对Transformer Decoder进行了一些改动，原本的Decoder包含了两个Multi-Head Attention结构，而GPT2只保留了Mask Multi-Head Attention。

## 推理

### 环境配置

在光源可拉取推理的docker镜像，GPT2模型推理的镜像如下： 

```python
docker pull image.sourcefind.cn:5000/dcu/admin/base/custom:ort_dcu_1.14.0_migraphx2.5.2_dtk22.10.1
```

在光合开发者社区可下载MIGraphX安装包，python依赖安装：

```python
pip install -r requirement.txt
```

本次采用GPT-2模型进行诗词生成任务，模型文件下载链接：https://pan.baidu.com/s/1KWeoUuakCZ5dualK69qCcw , 提取码：4pmh ，并将GPT2_shici.onnx模型文件保存在model文件夹下。

### 运行示例

我们提供了基于MIGraphX的推理脚本，版本依赖：

- Migraphx(DCU版本) >= 2.5.2

gpt2.py是基于Migraphx的推理脚本，使用需安装好MIGraphX，由于GPT2模型是动态推理的，需要设置动态shape模式，再执行推理。使用方法：

```python
# 设置动态shape模式
export MIGRAPHX_DYNAMIC_SHAPE=1

# 执行推理
python gpt2.py
```

推理结果为：

<img src="./Sample_picture.png" style="zoom:90%;" align=middle>

## 历史版本

https://developer.hpccube.com/codes/modelzoo/gpt2_migraphx

## 参考资料

https://github.com/yangjianxin1/GPT2-chitchat

https://github.com/Morizeyao/GPT2-Chinese